/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.monitoring;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.monitoring.jmx.JmxMetricsExposer;
import com.atlassian.jira.monitoring.jmx.analytics.JmxStartExposingAnalyticsEvent;
import com.atlassian.jira.monitoring.jmx.analytics.JmxStopExposingAnalyticsEvent;
import com.atlassian.jira.rest.v2.monitoring.MonitoringController;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="monitoring/jmx")
public class JmxMonitoringController
extends MonitoringController {
    private final JmxMetricsExposer jmxMetricsExposer;
    private final EventPublisher eventPublisher;

    @Inject
    public JmxMonitoringController(@Nonnull @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @Nonnull @ComponentImport GlobalPermissionManager permissionManager, @Nonnull @ComponentImport JmxMetricsExposer jmxMetricsExposer, @Nonnull @ComponentImport EventPublisher eventPublisher) {
        super(permissionManager, jiraAuthenticationContext);
        this.jmxMetricsExposer = Objects.requireNonNull(jmxMetricsExposer, "jmxMetricsExposer");
        this.eventPublisher = Objects.requireNonNull(eventPublisher, "eventPublisher");
    }

    @POST
    @WebSudoRequired
    @Path(value="startExposing")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response start() {
        return this.onlyAsAdmin(() -> {
            this.eventPublisher.publish((Object)new JmxStartExposingAnalyticsEvent());
            this.jmxMetricsExposer.startExposing();
            this.jmxMetricsExposer.publishRefreshMessage();
            return Response.ok().build();
        });
    }

    @POST
    @WebSudoRequired
    @Path(value="stopExposing")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response stop() {
        return this.onlyAsAdmin(() -> {
            this.eventPublisher.publish((Object)new JmxStopExposingAnalyticsEvent());
            this.jmxMetricsExposer.stopExposing();
            this.jmxMetricsExposer.publishRefreshMessage();
            return Response.ok().build();
        });
    }

    @GET
    @Path(value="getAvailableMetrics")
    @Produces(value={"application/json"})
    public Response getAvailableMetrics() {
        return this.onlyAsAdmin(() -> Response.ok((Object)this.jmxMetricsExposer.getExposedMetricNames()).build());
    }

    @GET
    @Path(value="areMetricsExposed")
    @Produces(value={"application/json"})
    public Response areMetricsExposed() {
        return this.onlyAsAdmin(() -> Response.ok((Object)this.jmxMetricsExposer.isJmxEnabled()).build());
    }
}

