/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.priority;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.PrioritySchemeService;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.util.ProjectKeyOrId;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.common.IdBean;
import com.atlassian.jira.rest.v2.issue.PrioritySchemeBean;
import com.atlassian.jira.rest.v2.priority.PrioritySchemeBeansFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="project/{projectKeyOrId}/priorityscheme")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public final class ProjectPrioritySchemeResource {
    private final PrioritySchemeService prioritySchemeService;
    private final ResponseFactory responseFactory;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PrioritySchemeBeansFactory prioritySchemeBeansFactory;

    @Inject
    public ProjectPrioritySchemeResource(PrioritySchemeService prioritySchemeService, ResponseFactory responseFactory, JiraAuthenticationContext jiraAuthenticationContext, PrioritySchemeBeansFactory prioritySchemeBeansFactory) {
        this.prioritySchemeService = prioritySchemeService;
        this.responseFactory = responseFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.prioritySchemeBeansFactory = prioritySchemeBeansFactory;
    }

    @PUT
    @ExperimentalApi
    public Response assignPriorityScheme(@Context UriInfo uriInfo, @PathParam(value="projectKeyOrId") String projectKeyOrId, IdBean prioritySchemeId) {
        ServiceOutcome result = this.prioritySchemeService.assignProject(this.jiraAuthenticationContext.getLoggedInUser(), prioritySchemeId.getId(), ProjectKeyOrId.parse(projectKeyOrId), true);
        if (!result.isValid()) {
            return this.responseFactory.errorResponse(result.getErrorCollection());
        }
        PrioritySchemeBean bean = this.prioritySchemeBeansFactory.buildResponseBean(this.jiraAuthenticationContext.getLoggedInUser(), uriInfo, (FieldConfigScheme)result.get());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)bean).cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Path(value="{schemeId}")
    @ExperimentalApi
    public Response unassignPriorityScheme(@Context UriInfo uriInfo, @PathParam(value="projectKeyOrId") String projectKeyOrId, @PathParam(value="schemeId") Long schemeId) {
        ServiceOutcome result = this.prioritySchemeService.unassignProject(this.jiraAuthenticationContext.getLoggedInUser(), schemeId, ProjectKeyOrId.parse(projectKeyOrId));
        if (!result.isValid()) {
            return this.responseFactory.errorResponse(result.getErrorCollection());
        }
        PrioritySchemeBean bean = this.prioritySchemeBeansFactory.buildResponseBean(this.jiraAuthenticationContext.getLoggedInUser(), uriInfo, (FieldConfigScheme)result.get());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)bean).cacheControl(CacheControl.never()).build();
    }

    @GET
    @ExperimentalApi
    public Response getAssignedPriorityScheme(@Context UriInfo uriInfo, @PathParam(value="projectKeyOrId") String projectKeyOrId) {
        ServiceOutcome outcome = this.prioritySchemeService.getSchemeForProject(this.jiraAuthenticationContext.getLoggedInUser(), ProjectKeyOrId.parse(projectKeyOrId));
        if (!outcome.isValid()) {
            return this.responseFactory.errorResponse(outcome.getErrorCollection());
        }
        PrioritySchemeBean bean = this.prioritySchemeBeansFactory.buildResponseBean(this.jiraAuthenticationContext.getLoggedInUser(), uriInfo, (FieldConfigScheme)outcome.get());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)bean).cacheControl(CacheControl.never()).build();
    }
}

