/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.user.anonymization;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.user.anonymization.ResultWithErrorsAndWarningsBean;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskProgressEvent;
import com.atlassian.jira.task.TaskProgressIndicator;
import com.atlassian.jira.user.anonymize.AnonymizationResult;
import com.atlassian.jira.user.anonymize.AnonymizeUserService;
import com.atlassian.jira.user.anonymize.AnonymizeUserTaskContext;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@JsonIgnoreProperties(ignoreUnknown=true)
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class UserAnonymizationProgressBean
extends ResultWithErrorsAndWarningsBean {
    public static final UserAnonymizationProgressBean DOC_EXAMPLE = new UserAnonymizationProgressBean("fred#2", "fred", "Fred Senior", "/rest/api/2/user/anonymization/progress?taskId=10001", 100L, "Name of a handler", new Date(), new Date(), new Date(), AnonymizationStatus.COMPLETED, Collections.emptyMap(), Collections.emptyMap(), (Set<String>)ImmutableSet.of((Object)"USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS", (Object)"USER_DISABLE", (Object)"USER_KEY_CHANGE_PLUGIN_POINTS", (Object)"USER_KEY_CHANGE", (Object)"USER_NAME_CHANGE_PLUGIN_POINTS", (Object)"USER_NAME_CHANGE", (Object[])new String[]{"USER_EXTERNAL_ID_CHANGE", "USER_ANONYMIZE_PLUGIN_POINTS"}), "node1", false);
    public static final UserAnonymizationProgressBean ERROR_DOC_EXAMPLE = new UserAnonymizationProgressBean("fred#2", "fred", "Fred Senior", "/rest/api/2/user/anonymization/progress?taskId=10002", 100L, "Name of a handler", new Date(), new Date(), new Date(), AnonymizationStatus.COMPLETED, (Map<String, ErrorCollection>)ImmutableMap.of((Object)"GENERAL", (Object)ErrorCollection.of("An error coming from general validation, e.g. permission validation or a user trying to anonymize themselves"), (Object)AnonymizeUserService.AnonymizeOperation.USER_KEY_CHANGE.toString(), (Object)ErrorCollection.of("Error coming from a particular operation step")), (Map<String, ErrorCollection>)ImmutableMap.of((Object)"com.atlassian.jira.example:plugin-module", (Object)ErrorCollection.of("Some warning message", "Another warning message"), (Object)"com.atlassian.jira.example2:different-plugin-module", (Object)ErrorCollection.of("An oopsie! Something went wrong!")), (Set<String>)ImmutableSet.of((Object)"USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS", (Object)"USER_DISABLE", (Object)"USER_KEY_CHANGE_PLUGIN_POINTS", (Object)"USER_KEY_CHANGE", (Object)"USER_NAME_CHANGE_PLUGIN_POINTS", (Object)"USER_NAME_CHANGE", (Object[])new String[]{"USER_EXTERNAL_ID_CHANGE", "USER_ANONYMIZE_PLUGIN_POINTS"}), "node1", false);
    public static final UserAnonymizationProgressBean VALIDATION_ERROR_DOC_EXAMPLE = new UserAnonymizationProgressBean("fred#2", "fred", "Fred Senior", "/rest/api/2/user/anonymization/progress?taskId=10002", 0L, "", new Date(), new Date(), new Date(), AnonymizationStatus.VALIDATION_FAILED, (Map<String, ErrorCollection>)ImmutableMap.of((Object)"com.atlassian.jira.example:plugin-module", (Object)ErrorCollection.of("An error coming from one of the operation steps, e.g. 'The target user for ownership transfer has to be an admin.'")), (Map<String, ErrorCollection>)ImmutableMap.of(), (Set<String>)ImmutableSet.of((Object)"USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS", (Object)"USER_DISABLE", (Object)"USER_KEY_CHANGE_PLUGIN_POINTS", (Object)"USER_KEY_CHANGE", (Object)"USER_NAME_CHANGE_PLUGIN_POINTS", (Object)"USER_NAME_CHANGE", (Object[])new String[]{"USER_EXTERNAL_ID_CHANGE", "USER_ANONYMIZE_PLUGIN_POINTS"}), "node1", true);
    @JsonProperty
    private String userKey;
    @JsonProperty
    private String userName;
    @JsonProperty
    private String fullName;
    @JsonProperty
    private String progressUrl;
    @JsonProperty
    private long currentProgress;
    @JsonProperty
    private String currentSubTask;
    @JsonProperty
    @JsonSerialize(using=Dates.DateTimeSerializer.class)
    @JsonDeserialize(using=Dates.DateTimeDeserializer.class)
    private Date submittedTime;
    @JsonProperty
    @JsonSerialize(using=Dates.DateTimeSerializer.class)
    @JsonDeserialize(using=Dates.DateTimeDeserializer.class)
    private Date startTime;
    @JsonProperty
    @JsonSerialize(using=Dates.DateTimeSerializer.class)
    @JsonDeserialize(using=Dates.DateTimeDeserializer.class)
    private Date finishTime;
    @JsonProperty
    private Set<String> operations;
    @JsonProperty
    private AnonymizationStatus status;
    @JsonProperty
    private String executingNode;
    @JsonProperty
    private boolean isRerun;

    private UserAnonymizationProgressBean() {
    }

    private UserAnonymizationProgressBean(String userKey, @Nullable String userName, @Nullable String fullName, String progressUrl, long currentProgress, @Nullable String currentSubTask, Date submittedTime, @Nullable Date startTime, @Nullable Date finishTime, @Nonnull AnonymizationStatus status, @Nonnull Map<String, ErrorCollection> errors, @Nonnull Map<String, ErrorCollection> warnings, @Nonnull Set<String> operations, @Nonnull String executingNode, boolean isRerun) {
        super(errors, warnings);
        this.userKey = Objects.requireNonNull(userKey);
        this.userName = userName;
        this.fullName = fullName;
        this.progressUrl = Objects.requireNonNull(progressUrl);
        this.currentProgress = currentProgress;
        this.currentSubTask = currentSubTask;
        this.submittedTime = Objects.requireNonNull(submittedTime);
        this.startTime = startTime;
        this.finishTime = finishTime;
        this.status = Objects.requireNonNull(status);
        this.operations = Objects.requireNonNull(operations);
        this.executingNode = Objects.requireNonNull(executingNode);
        this.isRerun = isRerun;
    }

    static UserAnonymizationProgressBean fromTaskDescriptor(TaskDescriptor<AnonymizationResult> task) {
        return UserAnonymizationProgressBean.fromTaskDescriptor(task, true);
    }

    static UserAnonymizationProgressBean fromTaskDescriptor(TaskDescriptor<AnonymizationResult> task, boolean isExecutingNodeAlive) {
        AnonymizeUserTaskContext taskContext = (AnonymizeUserTaskContext)task.getTaskContext();
        TaskProgressEvent lastProgressEvent = Optional.ofNullable(task.getTaskProgressIndicator()).map(TaskProgressIndicator::getLastProgressEvent).orElse(null);
        long progress = lastProgressEvent != null ? lastProgressEvent.getTaskProgress() : 0L;
        String currentSubTask = lastProgressEvent != null ? lastProgressEvent.getCurrentSubTask() : null;
        Map<String, ErrorCollection> errors = UserAnonymizationProgressBean.getErrors(task);
        Map<String, ErrorCollection> warnings = UserAnonymizationProgressBean.getWarnings(task);
        Set<String> operations = UserAnonymizationProgressBean.getOperations(task);
        AnonymizationStatus status = UserAnonymizationProgressBean.getAnonymizationStatus(task, isExecutingNodeAlive);
        String nodeId = task.getNodeId() != null ? task.getNodeId() : "";
        boolean isRerun = taskContext.isRerun();
        return new UserAnonymizationProgressBean(taskContext.getUserKey(), taskContext.getUserName(), taskContext.getFullName(), task.getProgressURL(), task.getFinishedTimestamp() != null ? 100L : progress, currentSubTask, task.getSubmittedTimestamp(), task.getStartedTimestamp(), task.getFinishedTimestamp(), status, errors, warnings, operations, nodeId, isRerun);
    }

    public String getUserKey() {
        return this.userKey;
    }

    @Nullable
    public String getUserName() {
        return this.userName;
    }

    @Nullable
    public String getFullName() {
        return this.fullName;
    }

    public String getProgressUrl() {
        return this.progressUrl;
    }

    public Long getCurrentProgress() {
        return this.currentProgress;
    }

    @Nullable
    public String getCurrentSubTask() {
        return this.currentSubTask;
    }

    public Date getSubmittedTime() {
        return this.submittedTime;
    }

    @Nullable
    public Date getStartTime() {
        return this.startTime;
    }

    @Nullable
    public Date getFinishTime() {
        return this.finishTime;
    }

    public AnonymizationStatus getStatus() {
        return this.status;
    }

    public Set<String> getOperations() {
        return this.operations;
    }

    public String getExecutingNode() {
        return this.executingNode;
    }

    public boolean isRerun() {
        return this.isRerun;
    }

    @Nonnull
    private static Map<String, ErrorCollection> getErrors(@Nonnull TaskDescriptor<AnonymizationResult> task) {
        if (!task.isFinished() && !UserAnonymizationProgressBean.isBusinessLogicValidationFailed(task)) {
            return Collections.emptyMap();
        }
        Map<String, ErrorCollection> errors = UserAnonymizationProgressBean.getErrorsFromOperationReport(((AnonymizationResult)task.getResult()).getOperationsReport());
        for (Map.Entry entry : ((AnonymizationResult)task.getResult()).getValidationErrors().entrySet()) {
            errors.merge((String)entry.getKey(), ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)entry.getValue()), ErrorCollection::addErrorCollection);
        }
        return errors;
    }

    private static Map<String, ErrorCollection> getWarnings(TaskDescriptor<AnonymizationResult> task) {
        if (!task.isFinished()) {
            return Collections.emptyMap();
        }
        AnonymizationResult result = (AnonymizationResult)task.getResult();
        Map validationWarnings = result.getValidationWarnings();
        Map<String, ErrorCollection> warningsFromValidation = UserAnonymizationProgressBean.convertErrorCollections(validationWarnings);
        Map<String, ErrorCollection> warningsFromOperationReport = UserAnonymizationProgressBean.getWarningsFromOperationReport(result.getOperationsReport());
        warningsFromValidation.putAll(warningsFromOperationReport);
        return warningsFromValidation;
    }

    private static Map<String, ErrorCollection> convertErrorCollections(Map<String, com.atlassian.jira.util.ErrorCollection> validationWarnings) {
        return validationWarnings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)entry.getValue())));
    }

    @Nonnull
    private static Set<String> getOperations(@Nonnull TaskDescriptor<AnonymizationResult> task) {
        if (!task.isFinished()) {
            return Collections.emptySet();
        }
        AnonymizationResult result = (AnonymizationResult)task.getResult();
        return result.getOperations().stream().map(Enum::toString).collect(Collectors.toSet());
    }

    private static AnonymizationStatus getAnonymizationStatus(TaskDescriptor<AnonymizationResult> task, boolean isExecutingNodeAlive) {
        if (UserAnonymizationProgressBean.isBusinessLogicValidationFailed(task)) {
            return AnonymizationStatus.VALIDATION_FAILED;
        }
        if (task.isFinished()) {
            return AnonymizationStatus.COMPLETED;
        }
        return isExecutingNodeAlive ? AnonymizationStatus.IN_PROGRESS : AnonymizationStatus.INTERRUPTED;
    }

    private static boolean isBusinessLogicValidationFailed(TaskDescriptor<AnonymizationResult> task) {
        if (task.getResult() == null) {
            return false;
        }
        return ((AnonymizationResult)task.getResult()).businessLogicValidationFailed();
    }

    public static enum AnonymizationStatus {
        COMPLETED,
        INTERRUPTED,
        IN_PROGRESS,
        VALIDATION_FAILED;

    }
}

