/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleStore;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class ApplicationRoleDataMatcher
extends TypeSafeMatcher<ApplicationRoleStore.ApplicationRoleData> {
    private Set<String> groups = Collections.emptySet();
    private Set<String> defaultGroups = Collections.emptySet();
    private ApplicationKey key;
    private boolean selectedByDefault;

    public ApplicationRoleDataMatcher match(ApplicationRoleStore.ApplicationRoleData data) {
        this.key = data.getKey();
        this.groups = data.getGroups();
        this.defaultGroups = data.getDefaultGroups();
        this.selectedByDefault = data.isSelectedByDefault();
        return this;
    }

    public ApplicationRoleDataMatcher merge(ApplicationRole role) {
        this.key(role.getKey());
        this.groups(role.getGroups().stream().map(Group::getName).collect(Collectors.toList()));
        this.defaultGroups(role.getDefaultGroups().stream().map(Group::getName).collect(Collectors.toList()));
        this.selectedByDefault(role.isSelectedByDefault());
        return this;
    }

    public ApplicationRoleDataMatcher selectedByDefault(boolean selectedByDefault) {
        this.selectedByDefault = selectedByDefault;
        return this;
    }

    public ApplicationRoleDataMatcher key(String key) {
        this.key = ApplicationKey.valueOf((String)key);
        return this;
    }

    public ApplicationRoleDataMatcher key(ApplicationKey key) {
        this.key = key;
        return this;
    }

    public ApplicationRoleDataMatcher groups(Iterable<String> groups) {
        this.groups = Sets.newHashSet(groups);
        return this;
    }

    public ApplicationRoleDataMatcher groups(String ... groups) {
        this.groups = Sets.newHashSet((Object[])groups);
        return this;
    }

    public ApplicationRoleDataMatcher defaultGroups(String ... defaultGroups) {
        this.defaultGroups = Sets.newHashSet((Object[])defaultGroups);
        return this;
    }

    public ApplicationRoleDataMatcher defaultGroups(Iterable<String> defaultGroups) {
        this.defaultGroups = Sets.newHashSet(defaultGroups);
        return this;
    }

    protected boolean matchesSafely(ApplicationRoleStore.ApplicationRoleData applicationRoleData) {
        return applicationRoleData.getKey().equals((Object)this.key) && applicationRoleData.getGroups().equals(this.groups) && applicationRoleData.getDefaultGroups().equals(this.defaultGroups) && applicationRoleData.isSelectedByDefault() == this.selectedByDefault;
    }

    public void describeTo(Description description) {
        description.appendText(String.format("[%s, %s, %s, %s]", this.key, this.groups, this.defaultGroups, this.selectedByDefault));
    }

    protected void describeMismatchSafely(ApplicationRoleStore.ApplicationRoleData item, Description mismatchDescription) {
        mismatchDescription.appendText(String.format("[%s, %s, %s, %s]", item.getKey(), item.getGroups(), item.getDefaultGroups(), this.selectedByDefault));
    }
}

