/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers;

import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Iterables;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class IterableMatchers {
    private IterableMatchers() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static <E> Matcher<Iterable<E>> emptyIterable(Class<E> elementType) {
        return Matchers.emptyIterable();
    }

    public static <E> Matcher<Iterable<E>> iterableWithSize(int expected, Class<E> elementType) {
        return Matchers.iterableWithSize((int)expected);
    }

    public static <E> Matcher<Iterable<E>> hasSizeOfAtLeast(int expectedMinimumSize, Class<E> elementType) {
        return IterableMatchers.hasSizeOfAtLeast(expectedMinimumSize);
    }

    public static <E> Matcher<Iterable<E>> hasSizeOfAtLeast(final int expectedMinimumSize) {
        Assertions.is((String)"Expected minimum size must be at least 0", (expectedMinimumSize >= 0 ? 1 : 0) != 0);
        return new TypeSafeDiagnosingMatcher<Iterable<E>>(){

            protected boolean matchesSafely(Iterable<E> items, Description mismatchDescription) {
                int size = Iterables.size(items);
                if (size < expectedMinimumSize) {
                    mismatchDescription.appendText("Expected size of at least ").appendValue((Object)expectedMinimumSize).appendText(" but was only ").appendValue((Object)size);
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("an iterable with size of at least ").appendValue((Object)expectedMinimumSize).appendText(" or more");
            }
        };
    }

    public static <E> Matcher<Iterable<E>> isSingleton(Class<E> type, E singleElement) {
        return IterableMatchers.isSingleton(singleElement);
    }

    public static <E> Matcher<Iterable<E>> isSingleton(E expectedElement) {
        return IterableMatchers.isSingleton(Matchers.is(expectedElement));
    }

    public static <E> Matcher<Iterable<E>> isSingleton(Matcher<E> singleElementMatcher) {
        return Matchers.allOf((Matcher)Matchers.iterableWithSize((int)1), IterableMatchers.hasItemThat(singleElementMatcher));
    }

    public static <E> Matcher<Iterable<E>> hasItems(Class<E> itemType, E ... items) {
        return Matchers.hasItems((Object[])items);
    }

    public static <E> Matcher<Iterable<E>> hasItemsThat(Class<E> itemType, Matcher<E> ... items) {
        return Matchers.hasItems(items);
    }

    public static <E> Matcher<Iterable<E>> hasItemThat(Matcher<E> itemMatcher) {
        return Matchers.hasItem(itemMatcher);
    }

    public static <E> Matcher<Iterable<E>> hasNoItemThat(Matcher<E> itemMatcher) {
        return Matchers.not(IterableMatchers.hasItemThat(itemMatcher));
    }

    public static <E> Matcher<Iterable<E>> containsAt(E item, int at) {
        return IterableMatchers.containsAt(Matchers.is(item), at);
    }

    public static <E> Matcher<Iterable<E>> containsFirst(E item) {
        return IterableMatchers.containsAt(item, 0);
    }

    public static <E> Matcher<Iterable<E>> containsFirst(Matcher<E> itemMatcher) {
        return IterableMatchers.containsAt(itemMatcher, 0);
    }

    public static <E> Matcher<Iterable<E>> containsLast(E item) {
        return IterableMatchers.containsLast(Matchers.is(item));
    }

    public static <E> Matcher<Iterable<E>> containsLast(final Matcher<E> itemMatcher) {
        return new TypeSafeDiagnosingMatcher<Iterable<E>>(){

            protected boolean matchesSafely(Iterable<E> items, Description mismatchDescription) {
                Object lastItem = Iterables.getLast(items);
                return itemMatcher.matches(lastItem);
            }

            public void describeTo(Description description) {
                description.appendText("an iterable containing an element at last position that matches ").appendDescriptionOf((SelfDescribing)itemMatcher);
            }
        };
    }

    public static <E> Matcher<Iterable<E>> containsAt(final Matcher<E> itemMatcher, final int at) {
        Assertions.is((String)"at must be at least 0", (at >= 0 ? 1 : 0) != 0);
        return Matchers.allOf(IterableMatchers.hasSizeOfAtLeast(at + 1), (Matcher)new TypeSafeDiagnosingMatcher<Iterable<E>>(){

            protected boolean matchesSafely(Iterable<E> items, Description mismatchDescription) {
                Object itemAt = Iterables.get(items, (int)at);
                return itemMatcher.matches(itemAt);
            }

            public void describeTo(Description description) {
                description.appendText("an iterable containing an element at position ").appendValue((Object)at).appendText(" that matches ").appendDescriptionOf((SelfDescribing)itemMatcher);
            }
        });
    }
}

