/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers;

import java.util.Comparator;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class OrderedSequenceMatcher<T>
extends TypeSafeDiagnosingMatcher<Iterable<T>> {
    private final Comparator<T> cmp;
    private String cmpDescription;

    private OrderedSequenceMatcher(String cmpDescription, Comparator<T> cmp) {
        this.cmpDescription = cmpDescription;
        this.cmp = cmp;
    }

    public static <T> OrderedSequenceMatcher<T> isOrdered(String cmpDescription, Comparator<T> cmp) {
        return new OrderedSequenceMatcher<T>(cmpDescription, cmp);
    }

    public static <T extends Comparable<T>> OrderedSequenceMatcher<T> isOrdered() {
        return new OrderedSequenceMatcher<T>("its natural order", Comparable::compareTo);
    }

    protected boolean matchesSafely(Iterable<T> ts, Description description) {
        Object prev = null;
        boolean prevSet = false;
        boolean result = true;
        for (T current : ts) {
            if (prevSet) {
                boolean valid = this.cmp.compare(prev, current) <= 0;
                result &= valid;
                description.appendText(valid ? " \u00e2\u0089\u00a4 " : " \u00e2\u0089\u00b0 ");
                description.appendValue(current);
                continue;
            }
            prev = current;
            prevSet = true;
            description.appendValue(prev);
        }
        return result;
    }

    public void describeTo(Description description) {
        description.appendText("The iterable should be ordered over " + this.cmpDescription);
    }
}

