/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.project;

import com.atlassian.jira.mock.ofbiz.MockGenericValue;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.ofbiz.core.entity.GenericValue;

public class MockVersion
implements Version {
    private static final AtomicLong SEQUENCE = new AtomicLong(1000L);
    private GenericValue genericValue;
    private Date startDate;
    private Date releaseDate;
    private Project project;
    private Long sequence;
    private boolean released = false;
    private boolean archived = false;
    private String description = null;

    public MockVersion() {
        this(1L, "test");
    }

    public static Version named(String versionName) {
        return new MockVersion(SEQUENCE.getAndIncrement(), versionName);
    }

    public MockVersion(GenericValue genericValue) {
        this.genericValue = genericValue;
    }

    public MockVersion(long id, String name) {
        this(id, name, null, null);
    }

    public MockVersion(long id, String name, Project project) {
        this(id, name, project, null);
    }

    public MockVersion(long id, String name, Project project, Long sequence) {
        this.genericValue = new MockGenericValue("Version", (Map<String, ?>)FieldMap.build((String)"id", (Object)new Long(id), (String)"name", (Object)name, (String)"sequence", (Object)sequence));
        this.sequence = sequence;
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public Long getProjectId() {
        if (this.project == null) {
            return null;
        }
        return this.project.getId();
    }

    public Project getProjectObject() {
        return this.project;
    }

    public MockVersion setProjectObject(Project project) {
        this.project = project;
        return this;
    }

    public Long getId() {
        return this.genericValue.getLong("id");
    }

    public void setId(Long id) {
        this.genericValue.set("id", (Object)id);
    }

    public String getName() {
        return this.genericValue.getString("name");
    }

    public void setName(String name) {
        this.genericValue.setString("name", name);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getSequence() {
        return this.sequence;
    }

    public void setSequence(Long sequence) {
        this.sequence = sequence;
        this.genericValue.set("sequence", (Object)sequence);
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public boolean isReleased() {
        return this.released;
    }

    public void setReleased(boolean released) {
        this.released = released;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Version clone() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(Date releasedate) {
        this.releaseDate = releasedate;
    }

    public String getString(String name) {
        return null;
    }

    public Timestamp getTimestamp(String name) {
        return null;
    }

    public Long getLong(String name) {
        return null;
    }

    public GenericValue getGenericValue() {
        return this.genericValue;
    }

    public void store() {
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

