/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.servlet;

import com.atlassian.jira.mock.servlet.MockPrincipal;
import com.atlassian.jira.util.collect.IteratorEnumeration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.apache.commons.collections.map.ListOrderedMap;

public class MockHttpServletRequest
implements HttpServletRequest {
    private Map parameterMap = new ListOrderedMap();
    private String contentType;
    private int contentLength = 0;
    private String requestURL = "http://mockservletrequest";
    private String servletPath;
    private String protocol;
    private String method;
    private String remoteAddr;
    private String contextPath;
    private String characterEncoding;
    private Locale locale;
    private Map headerMap = new HashMap();
    private Map attributeMap = new HashMap();
    private final ServletInputStream servletInputStream;
    private final BufferedReader bufferedReader;
    private HttpSession httpSession;
    private List<Cookie> cookies = Lists.newArrayList();
    private Map<String, String> cookieMap;
    private ServletContext servletContext;
    private DispatcherType dispatcherType;

    public MockHttpServletRequest() {
        this((BufferedReader)null);
    }

    public MockHttpServletRequest(ServletInputStream servletInputStream) {
        this.servletInputStream = servletInputStream;
        this.bufferedReader = null;
    }

    public MockHttpServletRequest(BufferedReader bufferedReader) {
        this.bufferedReader = bufferedReader;
        this.servletInputStream = null;
    }

    public MockHttpServletRequest(HttpSession httpSession) {
        this.servletInputStream = null;
        this.bufferedReader = null;
        this.httpSession = httpSession;
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public MockHttpServletRequest setCookies(Cookie[] cookies) {
        this.cookies.clear();
        if (cookies != null) {
            this.cookies.addAll(Arrays.asList(cookies));
        }
        return this;
    }

    public MockHttpServletRequest setCookies(Map<String, String> cookies) {
        return this.setCookies(this.toCookies(cookies));
    }

    public MockHttpServletRequest addCookie(Cookie cookie) {
        this.cookies.add(cookie);
        return this;
    }

    public MockHttpServletRequest addCookie(String name, String value) {
        return this.addCookie(new Cookie(name, value));
    }

    public Cookie[] toCookies(Map<String, String> cookieMap) {
        if (cookieMap == null || cookieMap.isEmpty()) {
            return null;
        }
        Cookie[] cookies = new Cookie[cookieMap.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : cookieMap.entrySet()) {
            cookies[i++] = new Cookie(entry.getKey(), entry.getValue());
        }
        return cookies;
    }

    public long getDateHeader(String string) {
        return 0L;
    }

    public String getHeader(String key) {
        return (String)this.headerMap.get(key);
    }

    public void setHeader(String key, String value) {
        this.headerMap.put(key, value);
    }

    public Enumeration getHeaders(String string) {
        Hashtable hashtable = new Hashtable(this.headerMap);
        return hashtable.elements();
    }

    public Enumeration getHeaderNames() {
        Hashtable hashtable = new Hashtable(this.headerMap);
        return hashtable.keys();
    }

    public int getIntHeader(String string) {
        return 0;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public MockHttpServletRequest setContextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    public String getQueryString() {
        StringBuilder queryString = new StringBuilder();
        Iterator iterator = this.parameterMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            queryString.append(entry.getKey()).append("=").append(((String[])entry.getValue())[0]);
            if (!iterator.hasNext()) continue;
            queryString.append("&");
        }
        return queryString.toString();
    }

    public String getRemoteUser() {
        return null;
    }

    public boolean isUserInRole(String string) {
        return false;
    }

    public Principal getUserPrincipal() {
        return new MockPrincipal();
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getRequestURI() {
        return this.requestURL;
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.requestURL);
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public HttpSession getSession(boolean b) {
        return this.httpSession;
    }

    public HttpSession getSession() {
        return this.httpSession;
    }

    public String changeSessionId() {
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public Object getAttribute(String key) {
        return this.attributeMap.get(key);
    }

    public Enumeration getAttributeNames() {
        return null;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        Charset.forName(encoding);
        this.characterEncoding = encoding;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public long getContentLengthLong() {
        return this.contentLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.servletInputStream;
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public void setParameter(String name, String value) {
        if (value == null) {
            this.parameterMap.remove(name);
        } else {
            this.parameterMap.put(name, new String[]{value});
        }
    }

    public Enumeration getParameterNames() {
        return IteratorEnumeration.fromIterator(this.parameterMap.keySet().iterator());
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameterMap.get(name);
    }

    public Map getParameterMap() {
        return Collections.unmodifiableMap(this.parameterMap);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getScheme() {
        return null;
    }

    public String getServerName() {
        return null;
    }

    public int getServerPort() {
        return 0;
    }

    public BufferedReader getReader() throws IOException {
        return this.bufferedReader;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteHost() {
        return null;
    }

    public void setAttribute(String key, Object value) {
        if (value != null) {
            this.attributeMap.put(key, value);
        } else {
            this.attributeMap.remove(key);
        }
    }

    public void removeAttribute(String string) {
    }

    public Locale getLocale() {
        return this.locale != null ? this.locale : Locale.getDefault();
    }

    public Enumeration<Locale> getLocales() {
        return IteratorEnumeration.fromIterable((Iterable)ImmutableList.of((Object)this.getLocale()));
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        return null;
    }

    public String getRealPath(String string) {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public String getLocalName() {
        return null;
    }

    public String getLocalAddr() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public void setRequestURL(String requestURL) {
        this.requestURL = requestURL;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void login(String username, String password) throws ServletException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Part getPart(String name) throws IOException, ServletException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isAsyncStarted() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isAsyncSupported() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public AsyncContext getAsyncContext() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setDispatcherType(DispatcherType dispatcherType) {
        this.dispatcherType = dispatcherType;
    }

    public DispatcherType getDispatcherType() {
        return this.dispatcherType;
    }
}

