/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.servlet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServletInputStream
extends ServletInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(MockServletInputStream.class);
    InputStream delegate;

    public MockServletInputStream(String input) {
        this(new ByteArrayInputStream(input.getBytes()));
    }

    public MockServletInputStream(InputStream delegate) {
        this.delegate = delegate;
    }

    public boolean isFinished() {
        try {
            return this.delegate.available() <= 0;
        }
        catch (IOException e) {
            LOG.warn("Exception occurred when checking for stream availability: ", (Throwable)e);
            return true;
        }
    }

    public boolean isReady() {
        return true;
    }

    public void setReadListener(ReadListener readListener) {
    }

    public int read() throws IOException {
        return this.delegate.read();
    }
}

