/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.issuetype.MockIssueType;
import com.atlassian.jira.mock.ofbiz.MockGenericValue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericValue;

public class MockProject
implements Project {
    private Long id;
    private String name;
    private String key;
    private String url;
    private String email;
    private ApplicationUser lead;
    private String description;
    private Long assigneeType;
    private Collection<ProjectComponent> projectComponents = Collections.emptyList();
    private Collection<Version> versions = Collections.emptyList();
    private GenericValue projectGV;
    private ProjectCategory projectCategory;
    private Avatar avatar;
    private Collection<IssueType> types;
    private ProjectTypeKey projectTypeKey;
    private boolean archived;
    private ApplicationUser archivedBy;
    private Date archivedDate;

    public MockProject(GenericValue gv) {
        this(gv.getLong("id"), gv.getString("key"), gv.getString("name"), gv);
    }

    public MockProject() {
    }

    public MockProject(long id) {
        this(id, (String)null, (String)null, (GenericValue)null);
    }

    public MockProject(Long id) {
        this(id, (String)null, (String)null, (GenericValue)null);
    }

    public MockProject(long id, String key) {
        this(id, key, key, (GenericValue)null);
    }

    public MockProject(long id, String key, ProjectTypeKey projectTypeKey) {
        this(id, key, null, null, projectTypeKey);
    }

    public MockProject(long id, String key, String name) {
        this(id, key, name, (GenericValue)null);
    }

    public MockProject(Long id, String key, String name) {
        this(id, key, name, (GenericValue)null);
    }

    public MockProject(long id, String key, String name, GenericValue projectGV) {
        this(new Long(id), key, name, projectGV);
    }

    public MockProject(Long id, String key, String name, GenericValue projectGV) {
        this(id, key, name, projectGV, null);
    }

    public MockProject(Long id, String key, String name, GenericValue projectGV, ProjectTypeKey projectTypeKey) {
        this.id = id;
        this.key = key;
        this.name = name;
        this.projectGV = projectGV;
        this.projectTypeKey = projectTypeKey;
    }

    public Long getAssigneeType() {
        return this.assigneeType;
    }

    public ProjectTypeKey getProjectTypeKey() {
        return this.projectTypeKey;
    }

    public void setAssigneeType(Long assigneeType) {
        this.assigneeType = assigneeType;
    }

    public Collection<ProjectComponent> getProjectComponents() {
        return this.projectComponents;
    }

    public void setProjectComponents(Collection<ProjectComponent> projectComponents) {
        this.projectComponents = projectComponents;
    }

    public Collection<ProjectComponent> getComponents() {
        return this.projectComponents;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public MockProject setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public Collection<Version> getVersions() {
        return this.versions;
    }

    public Collection<IssueType> getIssueTypes() {
        return this.types;
    }

    public MockProject setIssueTypes(IssueType ... types) {
        return this.setIssueTypes(Arrays.asList(types));
    }

    public MockProject setIssueTypes(Collection<IssueType> types) {
        this.types = types;
        return this;
    }

    public MockProject setIssueTypes(String ... types) {
        ArrayList<IssueType> output = new ArrayList<IssueType>(types.length);
        for (String type : types) {
            output.add(new MockIssueType(type, type));
        }
        return this.setIssueTypes(output);
    }

    public ProjectCategory getProjectCategory() {
        return this.projectCategory;
    }

    public ProjectCategory getProjectCategoryObject() {
        return this.getProjectCategory();
    }

    public void setProjectCategory(ProjectCategory projectCategory) {
        this.projectCategory = projectCategory;
    }

    public void setVersions(Collection<Version> versions) {
        this.versions = versions;
    }

    public GenericValue getGenericValue() {
        if (this.projectGV != null) {
            return this.projectGV;
        }
        MockGenericValue gv = new MockGenericValue("Project");
        gv.set("id", this.getId());
        gv.set("name", this.getName());
        gv.set("key", this.getKey());
        gv.set("description", this.getDescription());
        gv.set("lead", ApplicationUsers.getKeyFor((ApplicationUser)this.lead));
        return gv;
    }

    public ApplicationUser getLead() {
        return this.lead;
    }

    public void setLead(ApplicationUser lead) {
        this.lead = lead;
    }

    public String getLeadUserName() {
        return this.lead.getName();
    }

    @Nonnull
    public Avatar getAvatar() {
        return this.avatar;
    }

    public ApplicationUser getProjectLead() {
        return this.lead;
    }

    public String getLeadUserKey() {
        return ApplicationUsers.getKeyFor((ApplicationUser)this.lead);
    }

    public String getOriginalKey() {
        return this.key;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public ApplicationUser getArchivedBy() {
        return this.archivedBy;
    }

    public Date getArchivedDate() {
        return this.archivedDate;
    }

    public void setAvatar(Avatar avatar) {
        this.avatar = avatar;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MockProject that = (MockProject)o;
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "Project: " + this.getName() + '(' + this.getId() + ')';
    }

    public void setProjectTypeKey(String projectTypeKey) {
        this.projectTypeKey = new ProjectTypeKey(projectTypeKey);
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public void setArchivedBy(ApplicationUser archivedBy) {
        this.archivedBy = archivedBy;
    }

    public void setArchivedDate(Date archivedDate) {
        this.archivedDate = archivedDate;
    }
}

