/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.MockUser;
import java.util.concurrent.atomic.AtomicLong;

public class MockApplicationUser
implements ApplicationUser {
    public static final AtomicLong SEQUENCE = new AtomicLong(10000L);
    private final String key;
    private final User user;
    public static final long FAKE_USER_DIRECTORY_ID = -1L;
    private final long id;
    private boolean active = true;

    public MockApplicationUser(String username) {
        this(IdentifierUtils.toLowerCase((String)username), (User)new MockUser(username));
    }

    public MockApplicationUser(String username, long directoryId) {
        this(IdentifierUtils.toLowerCase((String)username), (User)new MockUser(username, directoryId));
    }

    public MockApplicationUser(String username, String displayName, String email) {
        this(IdentifierUtils.toLowerCase((String)username), (User)new MockUser(username, displayName, email));
    }

    public MockApplicationUser(String userKey, String username) {
        this(userKey, (User)new MockUser(username));
    }

    public MockApplicationUser(String userKey, String username, String displayName, String email) {
        this(userKey, (User)new MockUser(username, displayName, email));
    }

    public MockApplicationUser(String userKey, User user) {
        this.id = SEQUENCE.getAndIncrement();
        this.key = userKey;
        this.user = user;
    }

    private MockApplicationUser(Builder builder) {
        this.key = builder.key;
        this.user = builder.user;
        this.id = builder.id;
        this.setActive(builder.active);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean isActive() {
        return this.active;
    }

    public MockApplicationUser setActive(boolean active) {
        this.active = active;
        if (this.user instanceof MockUser) {
            ((MockUser)this.user).setActive(active);
        }
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public String getEmailAddress() {
        return this.user.getEmailAddress();
    }

    public String getDisplayName() {
        return this.user.getDisplayName();
    }

    public User getDirectoryUser() {
        return this.user;
    }

    public String getUsername() {
        return this.user.getName();
    }

    public String getName() {
        return this.user.getName();
    }

    public long getDirectoryId() {
        return this.user.getDirectoryId();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ApplicationUser) {
            ApplicationUser other = (ApplicationUser)obj;
            return this.key.equals(other.getKey());
        }
        if (obj instanceof User) {
            throw new IllegalArgumentException("You must update your code to use ApplicationUser (you passed User to equals here)");
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "MockApplicationUser{key='" + this.key + '\'' + ", user=" + this.user + ", id=" + this.id + ", active=" + this.active + '}';
    }

    public Long getId() {
        return this.id;
    }

    public static final class Builder {
        private String key;
        private User user;
        private long id;
        private boolean active;

        private Builder() {
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder user(User user) {
            this.user = user;
            return this;
        }

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder active(boolean active) {
            this.active = active;
            return this;
        }

        public MockApplicationUser build() {
            return new MockApplicationUser(this);
        }
    }
}

