/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.user.ApplicationUserEntity;
import com.atlassian.jira.user.util.UserKeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;

public class MockUserKeyStore
implements UserKeyStore {
    private int nextId = 10001;
    private Map<String, String> keyToUsernameMap = new HashMap<String, String>();
    private Map<String, String> usernameToKeyMap = new HashMap<String, String>();

    public String getUsernameForKey(String key) {
        return this.keyToUsernameMap.get(key);
    }

    public String getKeyForUsername(String username) {
        if (username == null) {
            return null;
        }
        String lowerUsername = IdentifierUtils.toLowerCase((String)username);
        return this.usernameToKeyMap.get(lowerUsername);
    }

    public void renameUser(String oldUsername, String newUsername) {
        oldUsername = IdentifierUtils.toLowerCase((String)oldUsername);
        newUsername = IdentifierUtils.toLowerCase((String)newUsername);
        String userkey = this.usernameToKeyMap.remove(oldUsername);
        this.usernameToKeyMap.put(newUsername, userkey);
        this.keyToUsernameMap.put(userkey, newUsername);
    }

    public String ensureUniqueKeyForNewUser(String username) {
        String lowerUsername = IdentifierUtils.toLowerCase((String)username);
        if (this.usernameToKeyMap.containsKey(lowerUsername)) {
            return this.usernameToKeyMap.get(lowerUsername);
        }
        String userkey = this.findUniqueKey();
        this.usernameToKeyMap.put(lowerUsername, userkey);
        this.keyToUsernameMap.put(userkey, lowerUsername);
        return userkey;
    }

    public String removeByKey(String key) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isSystemKey(String key) {
        return false;
    }

    public String getKeyFromId(long id) {
        return "KEY" + id;
    }

    @Nonnull
    public Optional<String> getUniqueKeyFromId(long id) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nonnull
    public Optional<String> getUniqueUsernameFromId(long id) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void changeKey(String oldUserKey, String newUserKey) {
        String username = this.keyToUsernameMap.get(oldUserKey);
        this.keyToUsernameMap.remove(oldUserKey);
        this.usernameToKeyMap.put(username, newUserKey);
        this.keyToUsernameMap.put(newUserKey, username);
    }

    public void setMapping(String key, String username) {
        this.keyToUsernameMap.put(key, username);
        this.usernameToKeyMap.put(IdentifierUtils.toLowerCase((String)username), key);
    }

    private String findUniqueKey() {
        while (this.nextId < 21000) {
            String potentialKey = String.valueOf(this.nextId);
            if (!this.keyToUsernameMap.containsKey(potentialKey)) {
                return potentialKey;
            }
            ++this.nextId;
        }
        throw new IllegalStateException("WTF!");
    }

    public Long getIdForUserKey(String name) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Optional<ApplicationUserEntity> getUserForId(Long id) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Optional<ApplicationUserEntity> getUserForKey(String key) {
        String username = this.keyToUsernameMap.get(key);
        return Optional.ofNullable(username).map(name -> new ApplicationUserEntity(Long.valueOf(-1L), key, name));
    }

    public Optional<ApplicationUserEntity> getUserForUsername(String username) {
        String key = this.usernameToKeyMap.get(IdentifierUtils.toLowerCase((String)username));
        return Optional.ofNullable(key).map(k -> new ApplicationUserEntity(Long.valueOf(-1L), k, username));
    }
}

