/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.util.JiraKeyUtils;

public class JiraKeyUtilsAccesor {
    public static void refreshKeyMatcherOnUtilClass() {
        JiraKeyUtils.setKeyMatcher((JiraKeyUtils.KeyMatcher)new JiraKeyUtils.ProductionKeyMatcher());
    }

    public static JiraKeyUtils.KeyMatcher getCurrentKeyMatcher() {
        return JiraKeyUtils.getCurrentKeyMatcher();
    }

    public static void setKeyMatcher(JiraKeyUtils.KeyMatcher keyMatcher) {
        JiraKeyUtils.setKeyMatcher((JiraKeyUtils.KeyMatcher)keyMatcher);
    }

    public static void resetKeyMatcher(String regex) {
        JiraKeyUtilsAccesor.setKeyMatcher((JiraKeyUtils.KeyMatcher)new JiraKeyUtils.ProductionKeyMatcher(regex));
    }

    public static class MockProductionKeyMatcher
    extends JiraKeyUtils.ProductionKeyMatcher {
        ApplicationProperties applicationProperties;
        IssueManager issueManager;

        public MockProductionKeyMatcher(String projectRegexp, ApplicationProperties applicationProperties, IssueManager issueManager) {
            super(projectRegexp);
            this.applicationProperties = applicationProperties;
            this.issueManager = issueManager;
        }

        ApplicationProperties getApplicationProperties() {
            return this.applicationProperties;
        }

        IssueManager getIssueManager() {
            return this.issueManager;
        }

        boolean canCurrentUserSeeIssue(Issue issue) {
            return true;
        }
    }

    public static class MockKeyMatcher
    extends JiraKeyUtils.DefaultKeyMatcher {
        public MockKeyMatcher(String projectRegex) {
            super(projectRegex);
        }
    }
}

