/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.searchers;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class MockSearcherFactory {
    public static Directory getCleanRAMDirectory() {
        try {
            RAMDirectory directory = new RAMDirectory();
            IndexWriterConfig conf = new IndexWriterConfig((Analyzer)new StandardAnalyzer());
            conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            new IndexWriter((Directory)directory, conf).close();
            return directory;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static IndexSearcher getSearcher(Directory directory) {
        try {
            return new IndexSearcher((IndexReader)DirectoryReader.open((Directory)directory));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static IndexSearcher getCleanSearcher() {
        return MockSearcherFactory.getSearcher(MockSearcherFactory.getCleanRAMDirectory());
    }
}

