/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.AssignableWorkflowSchemeStore;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.MockAssignableWorkflowSchemeState;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MockAssignableWorkflowSchemeStore
implements AssignableWorkflowSchemeStore {
    private long lastId = 0L;
    private Map<Long, AssignableWorkflowSchemeStore.AssignableState> workflowState = Maps.newHashMap();

    public AssignableWorkflowSchemeStore.AssignableState create(AssignableWorkflowSchemeStore.AssignableState state) {
        MockAssignableWorkflowSchemeState.Builder builder = new MockAssignableWorkflowSchemeState.Builder(state);
        builder.setId(++this.lastId);
        return this.addState(builder.build());
    }

    public AssignableWorkflowSchemeStore.AssignableState addState(AssignableWorkflowSchemeStore.AssignableState state) {
        state = new MockAssignableWorkflowSchemeState.Builder(state).build();
        this.workflowState.put(state.getId(), state);
        return state;
    }

    public AssignableWorkflowSchemeStore.AssignableState addStateForScheme(AssignableWorkflowScheme scheme) {
        return this.addState(((AssignableWorkflowSchemeStore.AssignableState.Builder)new MockAssignableWorkflowSchemeState.Builder().setId(scheme.getId()).setName(scheme.getName()).setDescription(scheme.getDescription()).setMappings(scheme.getMappings())).build());
    }

    public AssignableWorkflowSchemeStore.AssignableState update(AssignableWorkflowSchemeStore.AssignableState state) {
        return this.addState(state);
    }

    public boolean delete(long id) {
        return this.workflowState.remove(id) != null;
    }

    public boolean delete(AssignableWorkflowSchemeStore.AssignableState state) {
        return this.delete(state.getId());
    }

    public AssignableWorkflowSchemeStore.AssignableState get(long id) {
        return this.workflowState.get(id);
    }

    public Iterable<AssignableWorkflowSchemeStore.AssignableState> getAll() {
        return this.workflowState.values();
    }

    public boolean renameWorkflow(String oldName, String newName) {
        boolean changed = false;
        for (AssignableWorkflowSchemeStore.AssignableState state : Lists.newArrayList(this.getAll())) {
            HashMap newMap = Maps.newHashMap();
            boolean newMapChanged = false;
            for (Map.Entry entry : state.getMappings().entrySet()) {
                if (oldName.equals(entry.getValue())) {
                    newMapChanged = true;
                    newMap.put(entry.getKey(), newName);
                    continue;
                }
                newMap.put(entry.getKey(), entry.getValue());
            }
            if (!newMapChanged) continue;
            this.addState(((AssignableWorkflowSchemeStore.AssignableState.Builder)state.builder().setMappings((Map)newMap)).build());
            changed = true;
        }
        return changed;
    }

    public Iterable<AssignableWorkflowSchemeStore.AssignableState> getSchemesUsingWorkflow(JiraWorkflow jiraWorkflow) {
        ArrayList<AssignableWorkflowSchemeStore.AssignableState> states = new ArrayList<AssignableWorkflowSchemeStore.AssignableState>();
        for (Map.Entry<Long, AssignableWorkflowSchemeStore.AssignableState> entry : this.workflowState.entrySet()) {
            AssignableWorkflowSchemeStore.AssignableState state = entry.getValue();
            if (!state.getMappings().containsValue(jiraWorkflow.getName())) continue;
            states.add(state);
        }
        return states;
    }

    public long getLastId() {
        return this.lastId;
    }

    public AssignableWorkflowSchemeStore.AssignableState.Builder builder() {
        return new MockAssignableWorkflowSchemeState.Builder();
    }
}

