/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.workflow;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.IOException;
import java.util.Map;

public class TransitionSerializer {
    private final ObjectMapper marshaller;
    private final Map<String, Object> data;

    public TransitionSerializer(Map<String, Object> data) {
        this.data = data;
        this.marshaller = new ObjectMapper().findAndRegisterModules().setSerializationInclusion(JsonInclude.Include.NON_NULL).setAnnotationIntrospector(TransitionSerializer.createJacksonJaxbAnnotationIntrospector());
    }

    public String getJson() throws IOException {
        return this.marshaller.writeValueAsString(this.data);
    }

    private static AnnotationIntrospector createJacksonJaxbAnnotationIntrospector() {
        JacksonAnnotationIntrospector jacksonIntrospector = new JacksonAnnotationIntrospector();
        JaxbAnnotationIntrospector jaxbIntrospector = new JaxbAnnotationIntrospector(TypeFactory.defaultInstance());
        return AnnotationIntrospector.pair((AnnotationIntrospector)jacksonIntrospector, (AnnotationIntrospector)jaxbIntrospector);
    }
}

