define("jira-dashboard-items/sprint-days-remaining-view", [
    'jquery',
    'underscore'
], function($, _) {

    // Refresh interval (minutes)
    var GADGET_REFRESH_INTERVAL = 15;

    function SprintDaysRemainingView(dashboardItemID){

        this.id = dashboardItemID;

    }

    SprintDaysRemainingView.prototype = {

        templates: GH.tpl.dashboardItems.sprintDaysRemaining,

        setElement: function(element){

            this.element = element;

        },

        /*
         * Render the configuration screen for the dashboard item
         * @param {Node}
         * @param {Object} requiredParams
         */
        renderConfigView: function (element, requiredParams) {

            element.html(this.templates.configuration(requiredParams));

            var form = $("form", element);
            var formCancel = $("input.cancel", form);

            var boardPicker = form.find("select[name=board-type]");

            this.boardPicker = boardPicker;
            this.prefix = requiredParams.prefix;

            form.on("submit", this.onSubmit.bind(this));
            formCancel.on("click", this.onCancel.bind(this));

            //  Events being listened to by controller
            this.boardPicker.bind("change", this.onBoardPickerChange.bind(this));

            //  To initially populate the sprintPicker
            this.boardPicker.trigger("change");

            $(this).trigger("refreshLayout");

        },

        /*
         * Render the  screen for the dashboard item
         * @param {Node} element
         * @param {Object} requiredParams
         */
        renderDashboardItem: function (element, requiredParams) {

            element.html(this.templates.render(requiredParams));

            $(this).trigger("refreshLayout");

        },

        showNoBoardsAvailableErrorMessage: function() {
            this._showErrorMessage(AJS.I18n.getText('gh.rapid.no.views'));
        },

        showRapidViewCannotBeFoundErrorMessage: function() {
            this._showErrorMessage( AJS.I18n.getText('gh.rapid.view.error.noview'));
        },

        showGadgetNotAllowedToRenderErrorMessage: function() {
            this._showErrorMessage(AJS.I18n.getText('error.gadget.gone'));
        },

        showSprintCannotBeFoundErrorMessage: function() {
            this._showErrorMessage(AJS.I18n.getText('gh.gadget.sprint.error.can.not.find.sprint'));
        },

        showSprintNotActiveErrorMessage: function() {
            this._showErrorMessage(AJS.I18n.getText('gh.gadget.sprint.error.selected.sprint.not.active'));
        },

        _showErrorMessage : function(message){
            this.element.html(this.templates.errorRenderingConfiguration({
                message: message
            }));

            $(this).trigger("refreshLayout");
        },

        renderCurrentSprints : function(newSprintList){

            var $sprintList = this.element.find("form select[name=sprint-type]");

            $sprintList.empty();

            $sprintList.append(this.templates.autoOption());

            _.each(newSprintList, function(sprintElem){
                $sprintList.append(this.templates.option({
                    text:   sprintElem.name,
                    value:  sprintElem.id
                }));
            }, this);

        },

        onSubmit: function(evt){

            evt.preventDefault();

            var form = $(evt.currentTarget);

            var isConfigured        = true,
                rapidViewId         = form.find("select[name=board-type]").val(),
                refresh             = form.find("input[name=refresh-interval]").prop('checked'),
                showAssignees       = form.find("input[name=showAssignees]").prop('checked'),
                showRapidViewName   = form.find("input[name=showRapidViewName]").prop('checked'),
                showSprintName      = form.find("input[name=showSprintName]").prop('checked'),
                sprintId            = form.find("select[name=sprint-type]").val();

            $(this).trigger("submit", {
                isConfigured:       isConfigured,
                rapidViewId:        rapidViewId,
                refresh:            refresh == true ? GADGET_REFRESH_INTERVAL : false,
                showAssignees:      showAssignees,
                showRapidViewName:  showRapidViewName,
                showSprintName:     showSprintName,
                sprintId:           sprintId
            });

        },

        onCancel : function(){
            $(this).trigger("cancel");
        },

        onBoardPickerChange: function(){
            $(this).trigger('boardChange', this.boardPicker.val());
        }

    };

    return SprintDaysRemainingView;
});