/**
 * Simple JS for toggling configuration features
 */
require(['jquery', 'wrm/context-path'], function(jQuery, wrmContextPath) {
    const toggleFeature = clickEvent => {
        const input = clickEvent.target;
        const featureId = input.id;
        const newValue = input.checked;
        const url = `${wrmContextPath()}/secure/SetFeatureEnabled.jspa`;

        jQuery.ajax({
            url,
            type: 'POST',
            data: { featureId, newValue }
        });
    };

    const initialiseEvents = () => jQuery('.software-feature input').on('click', toggleFeature);

    jQuery(initialiseEvents);
});
