AJS.test.require(["com.pyxis.greenhopper.jira:gh-admin-labs"], function () {
    var $ = require('jquery');
    var LabsConfiguration = require("jira-agile/admin/labs/labs-configuration");

    var checkboxWrapper;
    var checkbox;

    module('Labs Configuration', {
        setup: function setup() {
            checkboxWrapper = document.createElement("DIV");
            checkboxWrapper.className = "checkbox";
            checkbox = document.createElement("INPUT");
            checkbox.setAttribute('type', 'checkbox');
            checkboxWrapper.appendChild(checkbox);
        },

        teardown: function teardown() {
            checkboxWrapper = undefined;
            checkbox = undefined;
        }
    });

    test("Call Ajax update labs feature when dialog confirmed", function () {
        this.stub($, 'ajax').returns(true);

        checkboxWrapper.setAttribute("data-confirm-disable-message", "Are you sure?");

        LabsConfiguration.onToggleLabsFeatureCheckbox.call(checkbox);

        ok($.ajax.notCalled);

        $('.ghx-dialog button').click();

        ok($.ajax.called);
    });

    test("Not call Ajax update labs feature when dialog canceled", function () {
        this.stub($, 'ajax').returns(true);

        checkboxWrapper.setAttribute("data-confirm-disable-message", "Are you sure?");

        LabsConfiguration.onToggleLabsFeatureCheckbox.call(checkbox);

        ok($.ajax.notCalled);

        $('.ghx-dialog a').click();

        ok($.ajax.notCalled);
        ok(checkbox.checked);
    });

    test("Call Ajax update labs feature immediately if confirm dialog does not need", function () {
        this.stub($, 'ajax').returns(true);

        checkbox.setAttribute("checked", true);

        LabsConfiguration.onToggleLabsFeatureCheckbox.call(checkbox);

        ok($.ajax.called);
    });
});