var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

define('jira-agile/admin/lexorank/services/lexorank-management-service', ['require'], function (require) {
    var formatter = require('jira/util/formatter');
    var Ajax = GH.Ajax;

    var LexoRankManagementService = function () {
        function LexoRankManagementService(model) {
            _classCallCheck(this, LexoRankManagementService);

            this.model = model;
        }

        _createClass(LexoRankManagementService, [{
            key: 'refreshBalanceStatus',
            value: function refreshBalanceStatus() {
                var _this = this;

                this.model.set({
                    balanceStatusInProgress: true,
                    balanceMessage: undefined
                });

                Ajax.get({ url: '/lexorank/balance' }, 'lexorankBalance').done(function (response) {
                    response.timestamp = new Date();
                    _this.model.set({
                        balanceStatusInProgress: false,
                        balanceStatus: response
                    });
                }).fail(function () {
                    return _this.model.set({
                        balanceStatusInProgress: false,
                        balanceStatus: {},
                        balanceMessage: { error: formatter.I18n.getText('gh.configuration.lexorank-manage.service.balance.error') }
                    });
                });
            }
        }, {
            key: 'requestBalanceAll',
            value: function requestBalanceAll() {
                var _this2 = this;

                this.model.set({
                    balanceStatusInProgress: true,
                    balanceMessage: undefined
                });

                Ajax.post({ url: '/lexorank/balance' }).done(function () {
                    return _this2.model.set({
                        balanceStatusInProgress: false,
                        balanceMessage: { success: formatter.I18n.getText('gh.configuration.lexorank-manage.service.balance.all.success') }
                    });
                }).fail(function () {
                    return _this2.model.set({
                        balanceStatusInProgress: false,
                        balanceMessage: { error: formatter.I18n.getText('gh.configuration.lexorank-manage.service.balance.all.error') }
                    });
                });
            }
        }, {
            key: 'requestBalanceField',
            value: function requestBalanceField(fieldId) {
                var _this3 = this;

                this.model.set({
                    balanceStatusInProgress: true,
                    balanceMessage: undefined
                });

                Ajax.post({ url: '/lexorank/balance?fieldId=' + fieldId }).done(function () {
                    return _this3.model.set({
                        balanceStatusInProgress: false,
                        balanceMessage: { success: formatter.I18n.getText('gh.configuration.lexorank-manage.service.balance.field.success', fieldId) }
                    });
                }).fail(function () {
                    return _this3.model.set({
                        balanceStatusInProgress: false,
                        balanceMessage: { error: formatter.I18n.getText('gh.configuration.lexorank-manage.service.balance.field.error', fieldId) }
                    });
                });
            }
        }, {
            key: 'runIntegrity',
            value: function runIntegrity() {
                var _this4 = this;

                this.model.set({
                    integrityCheckInProgress: true,
                    integrityMessage: undefined
                });

                Ajax.get({ url: '/lexorank/integrity' }, 'integrityCheck').done(function (response) {
                    response.timestamp = new Date();
                    _this4.model.set({
                        integrityCheckInProgress: false,
                        integrityCheck: response
                    });
                }).fail(function () {
                    return _this4.model.set({
                        integrityCheckInProgress: false,
                        integrityMessage: { error: formatter.I18n.getText('gh.configuration.lexorank-manage.service.integrity.error') }
                    });
                });
            }
        }]);

        return LexoRankManagementService;
    }();

    return LexoRankManagementService;
});

AJS.namespace('GH.LexoRankManagementService', null, require('jira-agile/admin/lexorank/services/lexorank-management-service'));