define('includes/js/field/epic-link-suggest-handler', ['jira/ajs/select/suggestions/checkbox-multi-select-suggest-handler'], function (CheckboxMultiselectSuggestHandler) {

    return CheckboxMultiselectSuggestHandler.extend({

        formatSuggestions: function formatSuggestions(descriptors, query) {

            var selectedDescriptors = this.model.getDisplayableSelectedDescriptors();

            var isNotSelectedItems = function isNotSelectedItems(item) {
                var selectedDescriptor;
                for (selectedDescriptor in selectedDescriptors) {
                    if (selectedDescriptors[selectedDescriptor].properties.value === item.properties.value.toString()) {
                        return false;
                    }
                }
                return true;
            };

            descriptors = _.map(descriptors, function (descriptor) {
                var items = _.filter(descriptor.properties.items, isNotSelectedItems);
                descriptor.properties.items = items;
                return descriptor;
            });
            return this._super(descriptors, query);
        }
    });
});

AJS.namespace('GH.EpicLinkSuggestHandler', null, require('includes/js/field/epic-link-suggest-handler'));