AJS.$.namespace("GH.gadget.rapid.fields");

/**
 * Rapid view picker.
 *
 * @param gadget
 * @param rapidViewIdUserPref the id under which the project is stored
 * @param rapidViewOptions the result of the ajax call that provides the available projects
 */
GH.gadget.rapid.fields.rapidViewPicker = function (gadget, rapidViewIdUserPref, rapidViewOptions) {
    return {
        userpref: rapidViewIdUserPref,
        label: gadget.getMsg("gh.gadget.userpref.rapid.view"),
        id: "rapid_view_picker_" + rapidViewIdUserPref,
        type: "callbackBuilder",
        callback: function callback(parentDiv) {
            // add a project options box and description. Note that the label has already been added
            parentDiv.append(AJS.$("<select/>").attr({
                id: rapidViewIdUserPref,
                name: rapidViewIdUserPref
            }).addClass('select'));

            // now fill the project list with values
            var $rapidViewSelectList = AJS.$("#" + rapidViewIdUserPref);
            $rapidViewSelectList.empty();

            //append the options to the rapidViewPicker, selecting the currently selected project
            var rapidViewIdUserPrefValue = gadget.getPref(rapidViewIdUserPref);
            rapidViewOptions.sort(GH.RapidBoard.viewModelComparator);
            AJS.$(rapidViewOptions).each(function () {
                var rapidViewOption = AJS.$("<option/>").attr("value", this.id).text(this.name);
                $rapidViewSelectList.append(rapidViewOption);
                if (this.id == rapidViewIdUserPrefValue) {
                    rapidViewOption.attr({ selected: "selected" });
                }
            });

            // bind a function to update the available quick filters when the selector changes.
            $rapidViewSelectList.change(function () {
                var rapidViewId = $rapidViewSelectList.find('option:selected').attr('value');
                AJS.$(AJS).trigger('config.rapidViewChanged', {
                    rapidViewId: rapidViewId
                });
            });
        }
    };
};

GH.gadget.rapid.fields.getSelectedRapidViewId = function (rapidViewIdUserPref) {
    return AJS.$("#" + rapidViewIdUserPref).find('option:selected').attr('value');
};

GH.gadget.rapid.fields.quickFilterPicker = function (gadget, quickFilterUserPref, rapidViewIdUserPref) {
    function updateQuickFilterList(selectedRapidViewId, $quickFilterList) {
        AJS.$.ajax({
            url: GH.Ajax.buildRestUrl('/gadgets/rapidview/pool/quickfilters/') + selectedRapidViewId,
            type: 'GET',
            dataType: 'json',
            success: function success(data) {
                var selectedQuickFilters = gadget.getPref(quickFilterUserPref).split("|");

                $quickFilterList.empty();

                AJS.$(data).each(function () {
                    var quickFilterOption = AJS.$("<option/>").attr("value", this.id).text(this.name);
                    $quickFilterList.append(quickFilterOption);
                    for (var i = 0, l = selectedQuickFilters.length; i < l; i++) {
                        if (selectedQuickFilters[i] == this.id) {
                            quickFilterOption.attr("selected", "selected");
                        }
                    }
                });
            }
        });
    }
    return {
        userpref: quickFilterUserPref,
        label: gadget.getMsg("gh.gadget.userpref.quick.filter"),
        id: "quick_filter_picker_" + quickFilterUserPref,
        type: "callbackBuilder",
        callback: function callback(parentDiv) {
            var selectAttrs = {
                id: quickFilterUserPref,
                name: quickFilterUserPref
            };

            var className = "multi-select";

            selectAttrs.multiple = "multiple";
            selectAttrs.size = "4";

            var $quickFilterList = AJS.$("<select>").attr(selectAttrs).addClass(className);
            parentDiv.append($quickFilterList);

            AJS.$('<input/>').attr({
                name: quickFilterUserPref,
                type: 'hidden',
                value: 'none'
            }).appendTo(parentDiv);

            var selectedRapidViewId = GH.gadget.rapid.fields.getSelectedRapidViewId(rapidViewIdUserPref);
            updateQuickFilterList(selectedRapidViewId, $quickFilterList);

            // get informed of changes
            AJS.$(AJS).bind('config.rapidViewChanged', function (event, args) {
                updateQuickFilterList(args.rapidViewId, $quickFilterList);
            });
        }
    };
};

GH.gadget.rapid.fields.sprintPicker = function (gadget, sprintIdUserPref, rapidViewIdUserPref, showAutoSprint, sprintsProvider) {
    function updateSprintList(selectedRapidViewId, $sprintList) {
        sprintsProvider(selectedRapidViewId).done(function (sprints) {
            var selectedSprint = gadget.getPref(sprintIdUserPref);

            $sprintList.empty();

            // check whether we should add the auto version
            if (showAutoSprint) {
                // create and add auto option
                var autoOptionValue = 'auto';
                var autoOption = AJS.$("<option />").addClass("next-release-option").val(autoOptionValue).text(gadget.getMsg("gh.gadget.sprint.option.auto"));
                if (selectedSprint == autoOptionValue) {
                    autoOption.attr("selected", "selected");
                }
                $sprintList.append(autoOption);
            }

            AJS.$.each(sprints, function (idx, sprint) {
                var sprintOption = AJS.$("<option/>").attr("value", sprint.id).text(sprint.name);
                $sprintList.append(sprintOption);
                if (selectedSprint == sprint.id) {
                    sprintOption.attr("selected", "selected");
                }
            });
        });
    }
    return {
        userpref: sprintIdUserPref,
        label: gadget.getMsg("gh.gadget.userpref.rapid.view"),
        id: "sprint_picker_" + sprintIdUserPref,
        type: "callbackBuilder",
        callback: function callback(parentDiv) {
            var selectAttrs = {
                id: sprintIdUserPref,
                name: sprintIdUserPref
            };

            var className = "select";

            var $sprintList = AJS.$("<select>").attr(selectAttrs).addClass(className);
            parentDiv.append($sprintList);

            var selectedRapidViewId = GH.gadget.rapid.fields.getSelectedRapidViewId(rapidViewIdUserPref);
            updateSprintList(selectedRapidViewId, $sprintList);

            // get informed of changes
            AJS.$(AJS).bind('config.rapidViewChanged', function (event, args) {
                updateSprintList(args.rapidViewId, $sprintList);
            });
        }
    };
};

GH.gadget.rapid.fields.versionPicker = function (gadget, versionIdUserPref, rapidViewIdUserPref, versionsProvider) {
    function updateVersionList(selectedRapidViewId, $versionList) {
        versionsProvider(selectedRapidViewId).done(function (versions) {
            var selectedVersion = gadget.getPref(versionIdUserPref);

            $versionList.empty();

            AJS.$.each(versions, function (idx, version) {
                var versionOption = AJS.$("<option/>").attr("value", version.id).text(version.name);
                $versionList.append(versionOption);
                if (selectedVersion == version.id) {
                    versionOption.attr("selected", "selected");
                }
            });

            GADGET.GH.versionListUpdatedHandler && GADGET.GH.versionListUpdatedHandler(versions);
        });
    }
    return {
        userpref: versionIdUserPref,
        label: gadget.getMsg("gh.gadget.userpref.version"),
        id: "version_picker_" + versionIdUserPref,
        type: "callbackBuilder",
        callback: function callback(parentDiv) {
            var selectAttrs = {
                id: versionIdUserPref,
                name: versionIdUserPref
            };

            var className = "select";

            var $versionList = AJS.$("<select>").attr(selectAttrs).addClass(className);
            parentDiv.append($versionList);

            var selectedRapidViewId = GH.gadget.rapid.fields.getSelectedRapidViewId(rapidViewIdUserPref);
            updateVersionList(selectedRapidViewId, $versionList);

            // get informed of changes
            AJS.$(AJS).bind('config.rapidViewChanged', function (event, args) {
                updateVersionList(args.rapidViewId, $versionList);
            });
        }
    };
};