AJS.$.namespace("GH.gadget.rapid.server");

GH.gadget.rapid.server.wrapDeferredWith = function(wrapped, f) {
    var deferred = AJS.$.Deferred();

    wrapped
        .done(function (data) {
            deferred.resolve(f(data));
        })
        .fail(deferred.reject);

    return deferred.promise();
};

GH.gadget.rapid.server.doLoadSprintsByBoardId = function(rapidViewId) {
    return GH.Ajax.get({
        url: '/sprintquery/' + rapidViewId,
        deferErrorHandling: true,
        data: {
            includeFutureSprints: false
        }
    }, "sprintsByBoard");
};

GH.gadget.rapid.server.doLoadVersionByBoardId = function(rapidViewId) {
    return GH.Ajax.get({
        url: '/xboard/plan/backlog/versions.json',
        data: {
            rapidViewId:rapidViewId
        }
    }, 'versionsListForReport');
};

GH.gadget.rapid.server.doLoadConfigByBoardId = function(rapidViewId) {
    return GH.Ajax.get({
        url: '/xboard/config.json',
        data: {rapidViewId: rapidViewId},
        deferErrorHandling: true
    });
};

GH.gadget.rapid.server.loadOpenSprintsByBoardId = function (rapidViewId) {
    return GH.gadget.rapid.server.wrapDeferredWith(GH.gadget.rapid.server.doLoadSprintsByBoardId(rapidViewId), function(data) {
        return _.where(data.sprints, {state: "ACTIVE"});
    });
};

GH.gadget.rapid.server.loadVersionsByBoardId = function (rapidViewId) {
    if (!rapidViewId) {
        var def = AJS.$.Deferred();
        setTimeout(function () { def.resolve([]); });
        return def.promise();
    }

    return GH.gadget.rapid.server.wrapDeferredWith(GH.gadget.rapid.server.doLoadVersionByBoardId(rapidViewId), function (data) {
        var versionList = [];
        _.each(data.versionData.versionsPerProject, function(versions,projectId) {
            versionList.push(_.map(versions,function(version){
                var project = _.findWhere(data.projects,{
                    id: parseInt(projectId,10)
                });
                return  {
                    id:version.id,
                    name:version.name,
                    projectKey:project.key
                };
            }));
        });
        return _.flatten(versionList);
    });
};

GH.gadget.rapid.server.loadConfigByBoardId = function(rapidViewId) {
    return GH.gadget.rapid.server.wrapDeferredWith(GH.gadget.rapid.server.doLoadConfigByBoardId(rapidViewId), function(data) {
        return data.currentViewConfig;
    });
};
