AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-gadget-rapid-view-resources"], function () {
    module("gh-gadget-rapid-view", {
        setup: function () {
            GH.Test.setUpFakeServer(this);
        },
        teardown: function () {
            GH.Test.restoreServer(this);
        }
    });

    test("loadAndRenderRapidViewGadget: Failed AJAX call show error message", sinon.test(function () {
        this.stub(GH.gadget.utils, "showInlineWarning");
        this.stub(GH.RapidBoard.ViewController, "preload");

        GH.Test.respondToGetWith500(this, "/xboard/config.json", {});

        var gadget = {
            getPref: function () {
                return 1;
            },
            getMsg: function () {
                return "";
            }
        };

        GH.RapidBoard.loadAndRenderRapidViewGadget(gadget);

        this.server.respond();

        ok(GH.gadget.utils.showInlineWarning.called, "Call show inline error message when ajax fails");
    }));
});
