/**
 * A temporary solution to show a warning message for some gadgets in IE9
 * since it is currently supported (as of Agile 6.7) but will be dropped shortly.
 * This won't be necessary once support for IE9 is dropped completely.
 * See https://jdog.jira-dev.com/browse/SW-1929 for more info.
 */
define('jira-agile/gadgets/unsupported-browser', ['require'], function (require) {
    'use strict';

    var $ = require('jquery');

    function isUnsupportedBrowser() {
        return $.browser.msie && parseInt($.browser.version, 10) <= 9;
    }

    return {
        /**
         * @param gadget for which to show a message if the browser is unsupported.
         * @returns {boolean} true if a message was shown.
         */
        showMessageIfUnsupported: function showMessageIfUnsupported(gadget) {
            if (isUnsupportedBrowser()) {
                gadget.getView().html(GH.tpl.gadget.unsupportedBrowser.message({
                    helpUrl: GH.HelpPaths.getHelpPath('supported.platforms').url
                }));
                return true;
            }
            return false;
        }
    };
});