/* global atl_token */
define('jira-agile/dialog/issue-actions', [
    'jira/ajs/select/queryable-dropdown-select',
    'jira/dialog/dialog',
    'jira/ajs/list/group-descriptor',
    'jira/ajs/list/item-descriptor',
    'jira/ajs/ajax/smart-ajax',
    'jira/focus/set-focus',
    'jquery'
], function(
    QueryableDropdownSelect,
    Dialog,
    GroupDescriptor,
    ItemDescriptor,
    SmartAjax,
    SetFocus,
    $
) {
    var IssueNavigator = JIRA.IssueNavigator;
    var Issue = JIRA.Issue;
    var DetailsModel = GH.DetailsObjectFactory.getDetailsModel();
    var wrmContextPath = require('wrm/context-path');

    /**
     * @constructor
     * @extends JIRA.Dialog
     */
    return Dialog.extend({
        _getDefaultOptions: function () {
            return $.extend(this._super(), {
                cached: false,
                id: "issue-actions-dialog",
                widthClass: "small"
            });
        },
        _setContent: function (content, decorate) {
            if (content) {
                this._super(content, decorate);
            } else {
                this._super($([
                    "<form id='issue-actions-dialog-form' class='aui ajs-dirty-warning-exempt'>",
                        "<div class='form-body'>",
                            "<div id='issueactions-suggestions' class='aui-list' />",
                            "<div class='description'>",
                            AJS.I18n.getText("issueactions.start.typing"),
                            "</div>",
                        "</div>",
                    "</form>"
                ].join('')), true);
            }
            if (Dialog.current === this) {
                var triggerConfig = new SetFocus.FocusConfiguration();
                triggerConfig.context = this.get$popup()[0];
                triggerConfig.parentElementSelectors = ['.form-body'];
                SetFocus.pushConfiguration(triggerConfig);
                SetFocus.triggerFocus();
            }
        },

        _formatActionsResponse: function (response) {

            function addSelected(issueId) {

                var url = window.location.href;
                var newUrl = url;

                if (/selectedIssueId=[0-9]*/.test(url)) {
                    newUrl = newUrl.replace(/selectedIssueId=[0-9]*/g, "selectedIssueId=" + issueId);
                } else {
                    if (IssueNavigator.isNavigator()) {
                        if (/\?/.test(url)) {
                            newUrl = newUrl + "&";
                        } else {
                            newUrl = newUrl + "?";
                        }
                        newUrl = newUrl + "selectedIssueId=" + issueId;
                    }
                }
                return encodeURIComponent(newUrl);
            }

            function addSelectedGH(issueKey) {
                return GH.RapidBoard.getCurrentPageReturnUrl();
            }

            function formatWorkflowResponse(workflowResponse) {
                var workflows = new GroupDescriptor({
                    label: AJS.I18n.getText("opsbar.more.transitions")
                });

                $(workflowResponse).each(function() {

                    // GreenHopper: make sure the issue id is not hardcoded, thus inserted by getAjaxOptions.
                    workflows.addItem(new ItemDescriptor({
                        href: wrmContextPath() + "/secure/WorkflowUIDispatcher.jspa?id={0}&action=" + this.action + "&atl_token=" + response.atlToken + "&returnUrl=" + addSelectedGH(response.key),
                        label: this.name,
                        styleClass: "issueaction-workflow-transition"
                    }));

                });

                return workflows;
            }

            function formatOperationResonse(operationsResponse) {

                var operations = new GroupDescriptor({
                    label: AJS.I18n.getText("common.words.actions")
                });

                $(operationsResponse).each(function() {
                    var _returnUrl = addSelectedGH(response.key);

                    // Rapid board only: Replace rank to top/bottom by send to top/bottom
                    var label = this.name;
                    if (DetailsModel.patchRankOperationName) {
                        label = DetailsModel.patchRankOperationName(this.styleClass, this.name);
                    }

                    var _concatOp = (this.url.indexOf('?') === -1) ? '?' : '&';
                    var _href = this.url + _concatOp + 'returnUrl=' + _returnUrl;

                    operations.addItem(new ItemDescriptor({
                        href: _href,
                        label: label,
                        styleClass: this.styleClass
                    }));
                });
                return operations;
            }

            var res = [];

            if (response) {
                if (response.actions && response.actions.length !== 0) {
                    res.push(formatWorkflowResponse(response.actions));
                }

                if (response.operations && response.operations.length !== 0) {
                    res.push(formatOperationResonse(response.operations));
                }

            }

            return res;
        },

        decorateContent: function () {
            var instance = this;
            var issueKey = IssueNavigator.getSelectedIssueKey();
            var issueId = Issue.getIssueId() || IssueNavigator.getSelectedIssueId();

            if (issueKey) {
                this.addHeading(AJS.I18n.getText("common.words.operations") + ": <span>" + issueKey + "</span>");
            } else {
                this.addHeading(AJS.I18n.getText("common.words.operations"));
            }

            this.queryControl = new QueryableDropdownSelect({
                id: "issueactions",
                element: this.$content.find("#issueactions-suggestions"),
                ajaxOptions: {
                    minQueryLength: 1,
                    dataType: "json",
                    url: AJS.format(wrmContextPath() + "/rest/api/1.0/issues/{0}/ActionsAndOperations?atl_token={1}", issueId, atl_token()),
                    formatResponse: this._formatActionsResponse
                },
                showDropdownButton: true,
                loadOnInit: true
            });
            this.queryControl._handleServerError  = function(smartAjaxResult) {
                var errMsg = SmartAjax.buildSimpleErrorContent(smartAjaxResult);
                var errorClass = smartAjaxResult.status === 401?'warning':'error';
                instance._setContent($('<div class="ajaxerror"><div class="aui-message ' + errorClass+'"><p>' + errMsg + '</p></div></div>'), false);
                instance._addCloseLink();
            };


            this.timeoutId = undefined;
            this._addCloseLink();

        },

        _addCloseLink : function() {
            var instance = this;
            var $closeLink;
            var $buttonContainer;
            var $buttons;

            $buttonContainer = $('<div class="buttons-container form-footer"></div>').appendTo(this.get$popupContent());
            $buttons = $('<div class="buttons"/>').appendTo($buttonContainer);
            $closeLink = $("<a href='#' class='cancel' id='aui-dialog-close'>" + AJS.I18n.getText("admin.common.words.close") + "</a>");
            $closeLink.appendTo($buttons, this.get$popupContent()).click(function(e) {
                instance.hide();
                e.preventDefault();
            });
            this.get$popupContent().append($buttonContainer);
        },

        hide: function (undim) {

            if (this._super(undim) === false) {
                return false;
            }

            SetFocus.popConfiguration();
        }
    });
});
