require(["jira/issuenavigator/issue-navigator", 'underscore', 'jira/dialog/dialog-register'], function(IssueNavigatorApi, _, JiraDialogs) {

    /**
     * GH Version of getAjaxOptions.
     *
     * issueId: comes from getSelectedIssueId(), which we overwrite in gh-issueactionspopup.js.
	 *   We always select an issue before performing an action (be it the cog menu, the dot menu or a drag and drop operation), so it is save to
	 *   simply fetch the selected issue.
     * linkIssueURI: either comes from the dot dialog (complete url in this case) or from the hidden links, where {0} is used for the issue id
     */
    JiraDialogs.getDefaultAjaxOptions = function() {
        var issueId = IssueNavigatorApi.getSelectedIssueId();
        var linkIssueURI = this.options.url || this.$activeTrigger.attr("href") || this.$activeTrigger.data("url");

        // replace {0} if present
        if (/id=\{0\}/.test(linkIssueURI)) {
            if (! issueId) {
                return false;
            } else {
                linkIssueURI = linkIssueURI.replace(/(id=\{0\})/, "id=" + issueId);
            }
        }

        // now return all requested data
	    return {
            data: {decorator: "dialog", inline: "true"},
            url: linkIssueURI
        };
    };

    /**
     * Stores the current issue id into session storage if the dialogs submits successfully
     */
    JiraDialogs.storeCurrentIssueIdOnSucessfulSubmit = function() {
        IssueNavigatorApi.setIssueUpdatedMsg({
            issueMsg: this.options.issueMsg,
            issueId: this.issueId,
            issueKey: this.issueKey
        });
        this.issueId = null;
        this.issueKey = null;
        GH.IssueOperationShortcuts.clearOverrideSelectedIssue();
    };
});
