
//Brought back from the future to use in GH before available via JIRA
//Taken from AJS with some modifications
//To be removed when AJS code available

(function () {

/**
 * @class Link
 * @constructor Link
 * @param page {number} page id
 * @param label {string} button label
 * @param onclick {function} [optional] click event handler
 * @param className {string} [optional] class name
 * @private
*/
function Link(page, label, onclick, className, url) {
    if (!page.buttonpanel) {
        page.addButtonPanel();
    }

    //if no url is given use # as default
    if(!url){
        url = "#";
    }

    this.page = page;
    this.onclick = onclick;
    this._onclick = function () {
        onclick.call(this, page.dialog, page);
    };
    this.item = AJS("a", label).attr("href", url).addClass("button-panel-link");
    if (className) {
        this.item.addClass(className);
    }
    if (typeof onclick == "function") {
        this.item.click(this._onclick);
    }
    page.buttonpanel.append(this.item);
    this.id = page.button.length;
    page.button[this.id] = this;
}

/**
* Method for adding a cancel link to the current page
* @method addCancel
* @param label {string} link label
* @param onclick {function} [optional] click event handler
* @return {object} the dialog
*/
if (! AJS.Dialog.prototype.addCancel) {
    AJS.Dialog.prototype.addCancel= function (label, onclick) {
        var page = this.page[this.curpage];
        var link = new Link(page, label, onclick, "button-panel-cancel-link");
        page.recalcSize();
        //return page;
    };
}

/**
 * This isn't yet in AUI, tracked in AJS-548
 *
 * @param uri
 * @param strict
 */
AJS.parseUri = function (uri, strict)
{
    function parseUri(str)
    {
        var o = parseUri.options,
                m = o.parser[o.strictMode ? "strict" : "loose"].exec(str),
                uri = {},
                i = 14;

        while (i--)
        {
            uri[o.key[i]] = m[i] || "";
        }

        uri[o.q.name] = {};
        uri[o.key[12]].replace(o.q.parser, function ($0, $1, $2)
        {
            if ($1)
            {
                if(typeof uri[o.q.name][$1] === "object")
                {
                    uri[o.q.name][$1].push($2);
                }
                else if(uri[o.q.name][$1])
                {
                    uri[o.q.name][$1] = [uri[o.q.name][$1], $2];
                }
                else
                {
                    uri[o.q.name][$1] = $2;
                }
            }
        });

        return uri;
    }

    parseUri.options = {
        strictMode: !!strict,
        key: ["source","protocol","authority","userInfo","user","password","host","port","relative","path","directory","file","query","anchor"],
        q:   {
            name:   "queryKey",
            parser: /(?:^|&)([^&=]*)=?([^&]*)/g
        },
        parser: {
            strict: /^(?:([^:\/?#]+):)?(?:\/\/((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?))?((((?:[^?#\/]*\/)*)([^?#]*))(?:\?([^#]*))?(?:#(.*))?)/,
            loose:  /^(?:(?![^:@]+:[^:@\/]*@)([^:\/?#.]+):)?(?:\/\/)?((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?)(((\/(?:[^?#](?![^?#\/]*\.[^?#\/.]+(?:[?#]|$)))*\/?)?([^?#\/]*))(?:\?([^#]*))?(?:#(.*))?)/
        }
    };

    uri = parseUri(uri);

    uri.toString = function () {
        var params = [];
        AJS.$.each(uri.queryKey, function (name, value) {
            if(_.isObject(value)) {
                AJS.$.each(value, function(index, innerVal) {
                    params.push(name + "=" + innerVal);
                });
            } else {
                params.push(name + "=" + value);
            }
        });
        return uri.protocol + "://" + uri.authority + uri.path + "?" + params.join("&") + "#" + uri.anchor;
    };

    return uri;
};
})();