/**
 * Plot an array of points as a simple floating barchart
 *
 * Expects data to be an array data points represented as an array with 2 values:
 *  - the first item contains the base of each bar
 *  - the second item contains the height of each bar
 */
c3.floatingBarChart = function () {
    return c3.component('floatingBarChart')
        .extend(c3.barChart())
        .yAccessor(function (d) {
            return d[0] + d[1];
        })
        .baselineAccessor(function (d) {
            return d[0];
        });
};