c3.utils = {
    /**
     * Split text into multiple positioned `tspans` to simulate wrapping to a given width
     *
     * @param text The text element to wrap
     * @param width The width of the wrapping container
     * @param {boolean} [above] if true, positions wrapped lines above instead of below the original position
     */
    wrapText: function (text, width, above) {
        text.each(function() {
            // Figure out lines
            var text = d3.select(this);
            var words = text.text().split(/\s+/).reverse();
            var line = [words.pop()];
            var lines = [line];
            var word;
            while (word = words.pop()) {
                line.push(word);
                text.text(line.join(' '));
                if (text.node().getComputedTextLength() > width) {
                    line.pop();
                    line = [word];
                    lines.push(line);
                }
            }

            // Create and position tspans
            text.text(null);
            var lineHeight = 1.1; //ems
            var y = text.attr('y') || 0;
            var dy = parseFloat(text.attr('dy')) || 0;
            lines.forEach(function (line, lineNumber) {
                if (above) {
                    lineNumber -= lines.length - 1;
                }
                text.append('tspan')
                    .attr({
                        x: width / 2,
                        y: y,
                        dy: lineNumber * lineHeight + dy + 'em'
                    })
                    .text(line.join(' '));
            });
        });
    },

    /**
     *
     * @param text The text element to truncate
     * @param widthAccessor The width of the bounding box the text must fit inside
     * @param heightAccessor The height of the bounding the text must fit inside
     */
    containText: function (text, widthAccessor, heightAccessor) {
        text.each(function() {
            var d = this.__data__;
            var text = d3.select(this);
            var textBounds = { width:0, height:0 };
            var padding = 4;

            try {
                textBounds = text.node().getBBox();
            } catch (e) {
                // Firefox throws inscrutable NS_ERROR_FAILURE
                // in situations where label is inside a group with no dimensions
            }

            if (textBounds.height + padding > heightAccessor(d)) {
                text.text('');
            } else if (textBounds.width + padding > widthAccessor(d)) {
                text.text('…');
            }
        });
    },

    /**
     * Applies a `viewBox` attribute to SVG element which allows entire element
     * to be scaled (especially for printing)
     *
     * @param {Object} selection Should be an SVG element
     */
    defaultViewBox: function (selection) {
        var dimensions = selection.node().parentNode.getBoundingClientRect();
        selection.attr('viewBox', '0 0 ' + dimensions.width + ' ' + dimensions.height);
    }
};
