AJS.test.require("com.pyxis.greenhopper.jira:gh-rapid-common", function () {
    module("Namespaces tests");

    var format = require('jira-agile/rapid/format');

    test("AJS.format is exported", function () {
        ok(AJS.format === format);
    });

    test("AJS.format with 1 parameter", function () {
        var testFormat = format("hello {0}", "world");
        strictEqual(testFormat, "hello world", "expected AJS.format to return: 'hello world'");
        notStrictEqual(testFormat, "hello {0}", "AJS.format rendered formatting successfully");
    });

    test("AJS.format with 2 parameters", function () {
        var testFormat = format("hello {0} {1}", "world", "again");
        strictEqual(testFormat, "hello world again", "expected AJS.format to return: 'hello world again'");
        notStrictEqual(testFormat, "hello {0} {1}", "AJS.format rendered formatting successfully");
    });

    test("AJS.format with 3 parameters", function () {
        var testFormat = format("hello {0} {1} {2}", "world", "again", "!");
        strictEqual(testFormat, "hello world again !", "expected AJS.format to return: 'hello world again !'");
        notStrictEqual(testFormat, "hello {0} {1} {2}", "AJS.format rendered formatting successfully");
    });

    test("AJS.format with 4 parameters", function () {
        var testFormat = format("hello {0} {1} {2} {3}", "world", "again", "!", "test");
        strictEqual(testFormat, "hello world again ! test", "expected AJS.format to return: 'hello world again ! test'");
        notStrictEqual(testFormat, "hello {0} {1} {2} {3}", "AJS.format rendered formatting successfully");
    });

    test("AJS.format with symbols", function () {
        var testFormat = format("hello {0}", "!@#$%^&*()");
        ok(testFormat == "hello !@#$%^&*()", "expected AJS.format to return: 'hello !@#$%^&*()'");
        notStrictEqual(testFormat, "hello {0}", "AJS.format rendered formatting successfully");
    });

    test("AJS.format with curly braces", function () {
        var testFormat = format("hello {0}", "{}");
        strictEqual(testFormat, "hello {}", "expected AJS.format to return: 'hello {}'");
        notStrictEqual(testFormat, "hello {0}", "AJS.format rendered formatting successfully");
    });

    test("AJS.format with repeated parameters", function () {
        var testFormat = format("hello {0}, {0}, {0}", "world");
        ok(testFormat == "hello world, world, world", "expected AJS.format to return: 'hello world, world, world'");
        ok(testFormat != "hello {0}, {0}, {0}", "AJS.format rendered formatting successfully");
    });

    test("AJS.format with apostrophe", function () {
        var testFormat = format("hello '{0}' {0} {0}", "world");
        strictEqual(testFormat, "hello {0} world world", "expected AJS.format to return: 'hello {0} world world'");
        notStrictEqual(testFormat, "hello world world", "AJS.format escaped curly braces successfully");
    });

    test("AJS.format with very long parameters", function () {
        var testFormat = format("hello {0}", "this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long ");
        strictEqual(testFormat, "hello this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long ", "expected AJS.format to return: 'hello this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long this parameter is very long '");
    });

    // choices

    test("AJS.format with a choice value", function () {
        var testFormat = format("We got {0,choice,0#0 issues}", 1);
        strictEqual(testFormat, "We got 0 issues", "expected AJS.format to return: 'We got 0 issues'");
    });

    test("AJS.format with a choice value", function () {
        var testFormat = format("We got {0,choice,0#0 issues|1#1 issues}", -1);
        strictEqual(testFormat, "We got 0 issues", "expected AJS.format to return: 'We got 0 issues'");
    });

    test("AJS.format with a choice value", function () {
        var testFormat = format("We got {0,choice,0#0 issues|1#1 issue|1<{0,number} issues}", 0);
        strictEqual(testFormat, "We got 0 issues", "expected AJS.format to return: 'We got 0 issues'");
    });

    test("AJS.format with a choice value", function () {
        var testFormat = format("We got {0,choice,0#0 issues|1#1 issue|1<{0,number} issues}", 1);
        strictEqual(testFormat, "We got 1 issue", "expected AJS.format to return: 'We got 1 issue'");
    });

    test("AJS.format with a choice value", function () {
        var testFormat = format("We got {0,choice,0#0 issues|1#1 issue|1<{0,number} issues}", 2);
        strictEqual(testFormat, "We got 2 issues", "expected AJS.format to return: 'We got 2 issues'");
    });

    test("AJS.format with a choice value", function () {
        var testFormat = format("We got {0,choice,0#|1#|1<{0,number} issues}", 1);
        strictEqual(testFormat, "We got ", "expected AJS.format to return: 'We got '");
    });

    test("AJS.format with a choice value", function () {
        var testFormat = format("We got {0,choice,0#|1#|1<{0,number} issues}", 2);
        strictEqual(testFormat, "We got 2 issues", "expected AJS.format to return: 'We got 2 issues'");
    });

    test("AJS.format with a choice value", function () {
        var testFormat = format("We got {0,choice,0#|1#|1<} issues", 2);
        strictEqual(testFormat, "We got  issues", "expected AJS.format to return: 'We got  issues'");
    });

    test("AJS.format with incorrect choice syntax in message", function () {
        var testFormat = format("We got {0,choice,0#0 issues|1#1 issue|1&lt;{0,number} issues}", 2);
        strictEqual(testFormat, "We got ", "expected AJS.format to return: 'We got '");
    });

    test("AJS.format with incorrect choice syntax in message", function () {
        var testFormat = format("We got {0,choice,0#0 issues|1\\#1 issue|1<{0,number} issues}", 1);
        strictEqual(testFormat, "We got ", "expected AJS.format to return: 'We got '");
    });

    test("AJS.format with incorrect choice syntax in message", function () {
        var testFormat = format("We got {0,choice,0# 0 issues |1#1 issue|1<{0,number} issues}", 0);
        strictEqual(testFormat, "We got  0 issues ", "expected AJS.format to return: 'We got  0 issues '");
    });

    test("AJS.format with incorrect choice syntax in message", function () {
        var testFormat = format("We got {0,choice}", 0);
        strictEqual(testFormat, "We got ", "expected AJS.format to return: 'We got '");
    });

    test("AJS.format with incorrect choice syntax in message", function () {
        var testFormat = format("We got {0,choice,0}", 0);
        strictEqual(testFormat, "We got ", "expected AJS.format to return: 'We got '");
    });

    test("AJS.format with incorrect choice syntax in message", function () {
        var testFormat = format("We got {0,choice,0#}", 0);
        strictEqual(testFormat, "We got ", "expected AJS.format to return: 'We got '");
    });

    test("AJS.Format with a choice value with a negative number", function () {
        var testFormat = format("Output is {0,choice,-1#negative|0#zero|1#positive}", -1);
        equal(testFormat, "Output is negative", "expected AJS.format to return: 'Output is negative'");
    });

    test("AJS.Format with a choice value with extra whitespace", function () {
        var testFormat = format("We got {0,choice,0# | 1# 1 issue | 1<{0,number} issues}", 1);
        equal(testFormat, "We got  1 issue ", "expected AJS.format to return: 'We got  1 issue '");
    });

    test("AJS.Format with a choice value with extra whitespace", function () {
        var testFormat = format("We got {0,choice,0# | 1# 1 issue | 1<{0,number} issues}", 2);
        equal(testFormat, "We got 2 issues", "expected AJS.format to return: 'We got 2 issues'");
    });

    // number

    test("AJS.format with a number value: positive integer", function () {
        var testFormat = format("An integer {0,number}!", 5);
        strictEqual(testFormat, "An integer 5!", "expected AJS.format to return: 'An integer 5!'");
    });

    test("AJS.format with a number value: negative integer", function () {
        var testFormat = format("A negative integer {0,number}!", -5);
        strictEqual(testFormat, "A negative integer -5!", "expected AJS.format to return: 'A negative integer -5!'");
    });

    test("AJS.format with a number value: no argument", function () {
        var testFormat = format("Give me {0,number}!");
        strictEqual(testFormat, "Give me !", "expected AJS.format to return: 'Give me !'");
    });

    test("AJS.format with a formated number with decimal mark", function () {
        var testFormat = format("A decimal {0,number}!", 5.5);
        strictEqual(testFormat, "A decimal 5.5!", "expected AJS.format to return: 'A decimal 5.5!'");
    });

    test("AJS.format with a formated number with digit group separator", function () {
        var testFormat = format("A large number {0,number}!", 1000);
        strictEqual(testFormat, "A large number 1,000!", "expected AJS.format to return: 'A large number 1,000!'");
    });

    test("AJS.format with a formated number with decimal mark and digit group separator", function () {
        var testFormat = format("A negative decimal {0,number}!", 1000.56);
        strictEqual(testFormat, "A negative decimal 1,000.56!", "expected AJS.format to return: 'A negative decimal 1,000.56!'");
    });

    test("AJS.format with a formated negative number with decimal mark", function () {
        var testFormat = format("A negative number {0,number}!", -5.5);
        strictEqual(testFormat, "A negative number -5.5!", "expected AJS.format to return: 'A negative number -5.5!'");
    });

    test("AJS.format with a formated negative number with digit group separator", function () {
        var testFormat = format("A large negative number {0,number}!", -1000);
        strictEqual(testFormat, "A large negative number -1,000!", "expected AJS.format to return: 'A large negative number -1,000!'");
    });

    test("AJS.format with a formatted number with digit group separator nested in a choice", function () {
        var testFormat = format("Contains {0,choice,0#0 nested numbers|1#1 nested number|1<{0,number} nested numbers}.", 1001);
        strictEqual(testFormat, "Contains 1,001 nested numbers.", "expected AJS.format to return: 'Contains 1,001 nested numbers.'");
    });
});