define('jira-agile/rapid/number-format', ['underscore', 'jira-agile/rapid/util'], function (_, Util) {

    var NumberFormat = {};

    /**
     * Defaults for these settings. They will be overwritten by locale-specific ones in GH.RapidViewConfig.handleData
     */
    NumberFormat.groupingSeparator = ",";
    NumberFormat.decimalSeparator = ".";

    /**
     * Format a number using locale-specific format.
     * Decimal numbers are capped at two decimal places (will only render decimal places if necessary).
     * @param n
     */
    NumberFormat.format = function (n) {
        if (!_.isNumber(n)) {
            return undefined;
        }

        // Round first
        n = Util.roundToDecimalPlaces(n, 2);

        // get the integer part of the number.
        // (bitwise operations cast the number into an integer, dropping the decimal part)
        var i = n << 0;

        // get the decimal part of the number.
        var d = n.toString().split('.')[1];

        // define a hacky String reverse function
        var reverse = function reverse(s) {
            return s.split("").reverse().join("");
        };

        // format the integer part of the number using our separator
        // inner to outer: reverse the number, add a separator after every third digit, and then reverse it again
        var is = reverse(reverse(i.toString()).replace(/(\d{3})(?=\d)/g, "$1" + NumberFormat.groupingSeparator));

        // combine!
        return is + (d ? NumberFormat.decimalSeparator + d : '');
    };

    /**
     * Format a number in (scientific) E notation with the coefficient and exponent in locale-specific format.
     * @param n
     * @returns {String}
     */
    NumberFormat.formatExponential = function (n) {
        if (!_.isNumber(n)) {
            return undefined;
        }

        var exp = Math.abs(n).toFixed(0).length - 1;
        var number = n / Math.pow(10, exp);

        return NumberFormat.format(number) + 'e' + NumberFormat.format(exp);
    };

    return NumberFormat;
});

AJS.namespace('GH.NumberFormat', null, require('jira-agile/rapid/number-format'));