AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function () {
    module("fetchConfiguration", {
        setup: function setup() {
            GH.Test.setUpFakeServer(this);
            GH.RapidViewConfig.currentData = {
                id: 1
            };
        },
        teardown: function teardown() {
            GH.Test.restoreServer(this);
        }
    });

    /* The purpose of these tests is to ensure the ajax calls are not broken while making a significant refactoring to how GH.Ajax works */
    test("Successful AJAX call passes on to handle the data", function () {

        sinon.stub(GH.RapidViewConfig, "handleData");

        GH.Test.respondToGetWith200(this, "/xboard/config.json", {});

        GH.RapidViewConfig.fetchConfiguration(null);

        this.server.respond();

        ok(GH.RapidViewConfig.handleData.called, "Called success method");
    });

    test("Failed AJAX call passes to handle authentication error", sinon.test(function () {
        this.stub(GH.RapidViewConfig, "handleRapidLoadError");

        GH.Test.respondToGetWith500(this, "/xboard/config.json", {});

        GH.RapidViewConfig.fetchConfiguration(null);

        this.server.respond();

        ok(GH.RapidViewConfig.handleRapidLoadError.called, "Called failure method");
    }));
});