AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common-base", "com.pyxis.greenhopper.jira:gh-rapid-config"], function () {
    var CardLayoutConfig = require('jira-agile/rapid/configuration/card-layout-config');
    var $ = require('jquery');

    module('CardLayoutConfig', {
        setup: function setup() {
            GH.Test.setUpFakeServer(this);
        },
        teardown: function teardown() {
            GH.Test.restoreServer(this);
        }
    });

    test('Renders two RESTful tables: one for plan mode, one for work mode', function () {
        var cardLayoutConfig = new CardLayoutConfig({
            isSprintSupportEnabled: true,
            cardLayoutConfig: {
                canEdit: true,
                availableFields: [],
                currentFields: [{ mode: 'workMode' }, { mode: 'planMode' }]
            }
        }, '#qunit-fixture');
        cardLayoutConfig.render();

        var tables = $('#qunit-fixture table');
        strictEqual(tables.length, 2, 'Rendered 2 tables');
    });

    test('Renders plan mode for enabled KanPlan kanban board', function () {
        var cardLayoutConfig = new CardLayoutConfig({
            isSprintSupportEnabled: false,
            isKanPlanEnabled: true,
            cardLayoutConfig: {
                canEdit: true,
                availableFields: [],
                currentFields: [{ mode: 'workMode' }, { mode: 'planMode' }]
            }
        }, '#qunit-fixture');
        cardLayoutConfig.render();

        var tables = $('#qunit-fixture table');
        strictEqual(tables.length, 2, 'Rendered 2 tables');
    });

    test('Renders only work mode for disabled KanPlan kanban board', function () {
        var cardLayoutConfig = new CardLayoutConfig({
            isSprintSupportEnabled: false,
            isKanPlanEnabled: false,
            cardLayoutConfig: {
                canEdit: true,
                availableFields: [],
                currentFields: [{ mode: 'workMode' }, { mode: 'planMode' }]
            }
        }, '#qunit-fixture');
        cardLayoutConfig.render();

        var tables = $('#qunit-fixture table');
        strictEqual(tables.length, 1, 'Rendered 1 table');
    });
});