define('jira-agile/rapid/configuration/estimation-config', ['require'], function (require) {

const formatter = require('jira/util/formatter');
const Ajax = GH.Ajax;

var analytics = require('jira/analytics');
var $ = require('jquery');

/**
 * Estimation configuration tab
 */
const EstimationConfig = {};

/**
 * Holds the model for the configuration.
 */
EstimationConfig.model = undefined;

/**
 * Initializes the Estimation config.
 */
EstimationConfig.init = function (data) {
    EstimationConfig.model = data.estimationStatisticConfig;

    EstimationConfig.initializeForm();
};

/**
 * Renders the edit form using the locally stored model
 */
EstimationConfig.initializeForm = function () {
    var model = EstimationConfig.model,
        params = {
            model: model,
            urls: {
                'estimationAndTracking': GH.HelpPaths.getHelpPath("estimation.and.tracking").url
            },
            currentTrackingStatisticIsNone: (model.currentTrackingStatistic.typeId == 'none'),
            trackingDescriptionNone: formatter.I18n.getText('gh.rapid.config.tracking.statistic.description.none', '<b>', AJS.escapeHTML(String(model.currentEstimationStatistic.name)), '</b>')
        };

    if (model.currentEstimationStatistic.id == 'issueCount_') {
        params.currentEstimateDescription = formatter.I18n.getText('gh.rapid.config.estimation.statistic.description.issuecount');
    } else if (model.currentEstimationStatistic.id == 'field_timeoriginalestimate') {
        params.currentEstimateDescription = formatter.I18n.getText('gh.rapid.config.estimation.statistic.description.originalestimate', '<b>', '</b>');
    } else {
        params.currentEstimateDescription = formatter.I18n.getText('gh.rapid.config.estimation.statistic.description.customfield', '<b>', AJS.escapeHTML(String(model.currentEstimationStatistic.name)), '</b>');
    }

    $('#ghx-config-estimation').html(GH.tpl.estimationconfig.renderEstimationConfigView(params));

    EstimationConfig.attachListeners();

};

EstimationConfig.attachListeners = function () {
    $('#ghx-estimatestatistic-select').change(EstimationConfig.save);
    $(':radio[name="ghx-trackingstatistic"]').change(EstimationConfig.save);
};

EstimationConfig.save = function () {
    // statistics field id
    var request = {
        estimateStatisticId: $('#ghx-estimatestatistic-select').val(),
        trackingStatisticId: $(':radio[name="ghx-trackingstatistic"]:checked').val(),
        rapidViewId: EstimationConfig.model.rapidViewId
    };

    var successFn = function (data) {
        // show message
        GH.Notification.showSuccess(formatter.I18n.getText('gh.rapid.config.estimation.save.success'));

        // update the model and reinitialise the form
        EstimationConfig.init({estimationStatisticConfig: data.success});

        if (!_.isUndefined(data.success.currentTrackingStatistic) && data.success.currentTrackingStatistic.isEnabled) {
            analytics.send({
                name: 'gh.config.tab.estimation.timeTracking.enable'
            });
        }
    };

    Ajax.put({
        url: '/rapidviewconfig/estimation',
        data: request,
        errorContextMap: {
            'estimatestatistic': '#ghx-estimatestatistic-select'
        }
    })
        .done(successFn);
};

return EstimationConfig;
});

AJS.namespace('GH.RapidBoard.Config.Estimation', null, require('jira-agile/rapid/configuration/estimation-config'));
