AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid-config"], function() {

    const FilterConfig = require("jira-agile/rapid/configuration/filter-config");

    module("Ajax tests", {
        setup: function() {
            GH.Test.setUpFakeServer(this);
            GH.RapidBoard.Config.FilterModel.id = 1;
        },
        teardown: function() {
            GH.Test.restoreServer(this);
        }
    });

    test("selectHandler: Successful AJAX call saves the filter", sinon.test(function() {
        var selected = {
            properties: {
                value: 1
            }
        };

        this.stub(GH.RapidBoard.Config.FilterModel, "setSavedFilter");
        this.stub(FilterConfig, "showFilter");

        GH.Test.respondToPutWith200(this, "/rapidviewconfig/filter", {});

        FilterConfig.selectHandler({}, selected);

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(GH.RapidBoard.Config.FilterModel.setSavedFilter.called, "Called success method");
        ok(FilterConfig.showFilter.called, "Called success method");

    }));

    test("selectHandler: Failed AJAX call does nothing (no error handling)", sinon.test(function() {
        var selected = {
            properties: {
                value: 1
            }
        };

        this.stub(GH.RapidBoard.Config.FilterModel, "setSavedFilter");
        this.stub(FilterConfig, "showFilter");

        GH.Test.respondToPutWith500(this, "/rapidviewconfig/filter", {});

        FilterConfig.selectHandler({}, selected);

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(!GH.RapidBoard.Config.FilterModel.setSavedFilter.called, "Nothing called when ajax fails");
        ok(!FilterConfig.showFilter.called, "Nothing called when ajax fails");
    }));


    test("updateOrderBy: Successful AJAX call reinitializes the form", sinon.test(function() {

        this.stub(GH.RapidBoard.Config.FilterModel, "setSavedFilter");
        this.stub(FilterConfig, "showFilter");

        var dialog = {
            enableControls: sinon.stub(),
            hide: sinon.stub()
        };

        GH.Test.respondToPutWith200(this, "/rapidviewconfig/orderbyrank", {});

        FilterConfig.updateOrderBy(dialog);

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(GH.RapidBoard.Config.FilterModel.setSavedFilter.called, "Called success method");
        ok(!dialog.enableControls.called);
    }));

    test("updateOrderBy: Failed AJAX call enables the dialog controls", sinon.test(function() {

        this.stub(GH.RapidBoard.Config.FilterModel, "setSavedFilter");
        this.stub(FilterConfig, "showFilter");

        var dialog = {
            enableControls: sinon.stub(),
            hide: sinon.stub()
        };

        GH.Test.respondToPutWith500(this, "/rapidviewconfig/orderbyrank", {});

        FilterConfig.updateOrderBy(dialog);

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(!GH.RapidBoard.Config.FilterModel.setSavedFilter.called, "Nothing called when ajax fails");
        ok(!FilterConfig.showFilter.called, "Nothing called when ajax fails");
        ok(dialog.enableControls.called);
    }));

    test("updateSubQuery: Successful AJAX call reinitializes the form", sinon.test(function() {

        this.stub(FilterConfig, "showFilter");
        this.stub(GH.RapidBoard.Config.FilterModel, "updateSubQuery");

        GH.Test.respondToPutWith200(this, "/subqueries/", {});

        FilterConfig.updateSubQuery(GH.FakeEvent);

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(GH.RapidBoard.Config.FilterModel.updateSubQuery.called, "Called success method");
    }));

    test("updateSubQuery: Failed AJAX call does nothing (no specific error handling)", sinon.test(function() {

        this.stub(FilterConfig, "showFilter");
        this.stub(GH.RapidBoard.Config.FilterModel, "updateSubQuery");

        GH.Test.respondToPutWith500(this, "/subqueries/", {});

        FilterConfig.updateSubQuery(GH.FakeEvent);

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(!GH.RapidBoard.Config.FilterModel.updateSubQuery.called, "Nothing called when ajax fails");
    }));
});