define('jira-agile/rapid/configuration/filter-config-model', ['underscore'], function (_) {
    const FilterModel = {};

    FilterModel.id = undefined;

    FilterModel.savedFilter = undefined;

    FilterModel.subQueries = [];

    FilterModel.canChangeFilter = undefined;

    FilterModel.canEditFilter = undefined;

    FilterModel.isSprintSupportEnabled = undefined;

    FilterModel.setModel = function(model) {
        FilterModel.id = model.id;
        FilterModel.setSavedFilter(model.filterConfig);
        FilterModel.canChangeFilter = model.canEdit;
        FilterModel.isSprintSupportEnabled = model.isSprintSupportEnabled;
        FilterModel.hasIssuesWithUnmappedStatuses = function() {
            var unmappedStatuses = model.rapidListConfig.unmappedStatuses;
            return _.any(unmappedStatuses, function(status) {
                return status.issueCount > 0;
            });
        };
        if (!model.isSprintSupportEnabled) {
            FilterModel.subQueries = model.subqueryConfig.subqueries;
        }
    };

    FilterModel.setSavedFilter = function(savedFilter) {
        FilterModel.savedFilter = savedFilter;
    };

    FilterModel.updateSubQuery = function(subQuery) {
        for (var i = 0; i < FilterModel.subQueries.length ; i++) {
            if (subQuery.section == FilterModel.subQueries[i].section) {
                FilterModel.subQueries[i] = subQuery;
                return;
            }
        }
    };

    FilterModel.getSubQuery = function() {
        return FilterModel.subQueries[0];
    };

    return FilterModel;
});

AJS.namespace('GH.RapidBoard.Config.FilterModel', null, require('jira-agile/rapid/configuration/filter-config-model'));
