AJS.test.require("com.pyxis.greenhopper.jira:gh-manage-boards",function(){var e=require("jira-agile/rapid/configuration/manage-boards-model"),t=function(e){for(var t=[],s=1;s<=e;s++)t.push({id:s,name:"Board "+s,canEdit:!0,sprintSupportEnabled:s%2===0,filter:{id:s,name:"Filter for board "+s,permissionEntries:[{values:[{type:"Project",name:"Project "+s}]}]},boardAdmins:{userKeys:[{key:"admin",displayName:"admin"}],groupKeys:[]}});return t};module("ManageBoardsModel",{setup:function(){this.generateBoards=t,this.model=new e,this.handler=sinon.spy(),this.model.on("change:boards",this.handler)}}),test("should have proper categories set",function(){var e=_.pluck(this.model.getBoardsCategories(),"id");deepEqual(e,["all"]),equal(this.model.getCurrentCategory().id,"all"),this.model.setRecentBoards(this.generateBoards(5)),e=_.pluck(this.model.getBoardsCategories(),"id"),deepEqual(e,["recent","all"]),equal(this.model.getCurrentCategory().id,"all"),this.model.setRecentBoards([]),e=_.pluck(this.model.getBoardsCategories(),"id"),deepEqual(e,["all"]),equal(this.model.getCurrentCategory().id,"all")}),test("should trigger event on category change",function(){this.model.setRecentBoards(this.generateBoards(5)),sinon.assert.calledOnce(this.handler),this.model.setCurrentCategory("all"),sinon.assert.calledTwice(this.handler)}),test("should properly return current boards",function(){this.model.setRecentBoards(this.generateBoards(2)),this.model.populate(this.generateBoards(20)),equal(this.model.getCurrentCategory().id,"all"),deepEqual(this.model.getCurrentBoards(),this.model.getAllBoards()),this.model.setCurrentCategory("recent"),equal(this.model.getCurrentCategory().id,"recent"),deepEqual(this.model.getCurrentBoards(),this.model.getRecentBoards())}),test("should properly return if boards are filterable",function(){equal(this.model.isFilterable(),!1),this.model.populate(this.generateBoards(10)),equal(this.model.isFilterable(),!0),this.model.setRecentBoards(this.generateBoards(2)),this.model.setCurrentCategory("recent"),equal(this.model.isFilterable(),!1),this.model.setCurrentCategory("all"),equal(this.model.isFilterable(),!0)}),test("should return proper pagination parameters",function(){this.model.populate(this.generateBoards(20));var e=this.model.getPaginationState();equal(e.firstPage,1),equal(e.totalPages,1),this.model.populate(this.generateBoards(60)),e=this.model.getPaginationState(),equal(e.firstPage,1),equal(e.lastPage,3),equal(e.totalPages,3),this.model.setRecentBoards(this.generateBoards(2)),this.model.setCurrentCategory("recent"),e=this.model.getPaginationState(),equal(e.firstPage,0),equal(e.totalPages,0)}),test("should change pages",function(){this.model.populate(this.generateBoards(60));var e=this.model.getPaginationState();equal(e.currentPage,1),equal(e.totalPages,3),this.model.changePage(3),e=this.model.getPaginationState(),equal(e.currentPage,3),equal(e.totalPages,3),this.model.changePage(-3),e=this.model.getPaginationState(),equal(e.currentPage,1),equal(e.totalPages,3),this.model.changePage(5),e=this.model.getPaginationState(),equal(e.currentPage,3),equal(e.totalPages,3)}),test("should remove boards",function(){this.model.populate(this.generateBoards(10)),this.model.setRecentBoards(this.generateBoards(2)),equal(this.model.getAllBoards().length,10),equal(this.model.getRecentBoards().length,2),this.model.removeBoard(5),equal(this.model.getAllBoards().length,9),equal(this.model.getRecentBoards().length,2),deepEqual(_.pluck(this.model.getAllBoards(),"id"),[1,2,3,4,6,7,8,9,10]),this.model.removeBoard(2),equal(this.model.getAllBoards().length,8),equal(this.model.getRecentBoards().length,1),deepEqual(_.pluck(this.model.getAllBoards(),"id"),[1,3,4,6,7,8,9,10]),deepEqual(_.pluck(this.model.getRecentBoards(),"id"),[1])}),test("should filter boards by text",function(){this.model.populate(this.generateBoards(11)),equal(this.model.getCurrentBoards().length,11),this.model.setTextFilter("Board 1"),this.model.filterBoards(),equal(this.model.getCurrentBoards().length,3),deepEqual(_.pluck(this.model.getCurrentBoards(),"id"),[1,10,11]),sinon.assert.calledTwice(this.handler),this.model.setRecentBoards(this.generateBoards(2)),this.model.setCurrentCategory("recent"),equal(this.model.getCurrentBoards().length,2),deepEqual(_.pluck(this.model.getCurrentBoards(),"id"),[1,2])}),test("should filter boards by unicode text",function(){var e="䩣ぴゅ",t=this.generateBoards(2);t[0].name=e,this.model.populate(t),equal(this.model.getCurrentBoards().length,2),this.model.setTextFilter("empty"),this.model.filterBoards(),equal(this.model.getCurrentBoards().length,0),this.model.setTextFilter(e),this.model.filterBoards(),equal(this.model.getCurrentBoards().length,1)}),test("text filter should not be case sensitive",function(){this.model.populate(this.generateBoards(6)),equal(this.model.getCurrentBoards().length,6),this.model.setTextFilter("BoArD 6"),this.model.filterBoards(),equal(this.model.getCurrentBoards().length,1)}),test("text filter should filter by admin names as well",function(){var e=this.generateBoards(10);e[0].boardAdmins.userKeys.push({key:"testuser",displayName:"testuser"}),e[5].boardAdmins.userKeys.push({key:"testuser",displayName:"testuser"}),this.model.populate(e),equal(this.model.getCurrentBoards().length,10),this.model.setTextFilter("user"),this.model.filterBoards(),equal(this.model.getCurrentBoards().length,2),deepEqual(_.pluck(this.model.getCurrentBoards(),"id"),[1,6]),this.model.setTextFilter("admin"),this.model.filterBoards(),equal(this.model.getCurrentBoards().length,10)}),test("should filter boards by type",function(){this.model.populate(this.generateBoards(5)),this.model.setTypeFilter(["kanban"]),this.model.filterBoards(),equal(this.model.getCurrentBoards().length,3),deepEqual(_.pluck(this.model.getCurrentBoards(),"id"),[1,3,5]),sinon.assert.calledTwice(this.handler),this.model.setRecentBoards(this.generateBoards(2)),this.model.setCurrentCategory("recent"),equal(this.model.getCurrentBoards().length,2),deepEqual(_.pluck(this.model.getCurrentBoards(),"id"),[1,2]),this.model.setTypeFilter(["scrum"]),this.model.setCurrentCategory("all"),this.model.filterBoards(),equal(this.model.getCurrentBoards().length,2),deepEqual(_.pluck(this.model.getCurrentBoards(),"id"),[2,4]),sinon.assert.callCount(this.handler,6)})});