GH.RapidBoard.Browsers = {};

GH.RapidBoard.Browsers.userAgentMap = {
    "mozilla": "Firefox"
};

GH.RapidBoard.Browsers.unsupportedBrowsers = [{
    name: "mozilla",
    versions: ["1.7", "1.8", "1.9"]
}];

/**
 * Browser Specific Behaviour
 */
GH.RapidBoard.Browsers.init = function () {

    // Notify if unsupported browser being used
    GH.RapidBoard.Browsers.unsupported();
};

GH.RapidBoard.Browsers.isLowerThanIE11 = function () {
    return AJS.$.browser.msie && parseFloat(AJS.$.browser.version) < 11;
};

GH.RapidBoard.Browsers.isGreaterThanIE9 = function () {
    return AJS.$.browser.msie && parseFloat(AJS.$.browser.version) > 9;
};

/**
 * Browser Event Support
 */

// The input event however the input event does not fire correctly in IE9 and not at all in IE8
// you should delegate to Keypress if it is not supported
GH.RapidBoard.Browsers.isInputEventSupported = function () {
    return 'oninput' in document.createElement('input') && !AJS.$.browser.msie || GH.RapidBoard.Browsers.isGreaterThanIE9();
};

/**
 * Based on JIRA's describeBrowser
 */
GH.RapidBoard.Browsers.describeBrowser = function (userAgent) {

    userAgent = userAgent || navigator.userAgent;

    var isChrome = /chrome/.test(navigator.userAgent.toLowerCase()),
        isSafari = !isChrome && /safari/.test(navigator.userAgent.toLowerCase()),
        match = AJS.$.uaMatch(userAgent),
        name = match.browser,
        version = match.version.replace(/(\d+)\.(\d+).*$/, "$1.$2");

    if (isChrome) {
        name = "chrome";
    } else if (isSafari) {
        name = "safari";
    }
    return { name: name, version: version };
};

/**
 * Notify if unsupported browser being used
 */
GH.RapidBoard.Browsers.unsupported = function () {

    var browser = GH.RapidBoard.Browsers.describeBrowser();
    var unsupported = GH.RapidBoard.Browsers.unsupportedBrowsers;
    var message;
    var i;
    var badBrowser;

    for (i = 0; i < unsupported.length; i++) {
        badBrowser = unsupported[i];
        if (browser.name == badBrowser.name && badBrowser.versions.indexOf(browser.version) >= 0) {
            var browserName = browser.name;
            if (GH.RapidBoard.Browsers.userAgentMap[browserName]) {
                browserName = GH.RapidBoard.Browsers.userAgentMap[browserName];
            }
            var docsUrl = GH.HelpPaths.getHelpPath("supported.platforms").url;
            message = GH.tpl.rapid.notification.renderMessageHolder({
                browser: browserName,
                docsUrl: docsUrl
            });
            AJS.$('body').prepend(message);
            break;
        }
    }
};

AJS.$(function () {
    // check if supported browser
    GH.RapidBoard.Browsers.init();
});