/* global QUnit */
AJS.test.require(['com.pyxis.greenhopper.jira:gh-test-common', 'com.pyxis.greenhopper.jira:gh-rapid'], function () {
    var $ = require('jquery');
    var BurndownChartView = require('jira-agile/rapid/ui/chart/burndown-chart-view');
    var BurndownChartModel = require('jira-agile/rapid/ui/chart/burndown-chart-model');
    var GlobalEvents = require('jira-agile/rapid/global-events');
    GlobalEvents.trigger('pre-initialization');

    module('non-working days');

    test('module "jira-agile/rapid/ui/chart/burndown-chart-view" exists', function () {
        ok(BurndownChartView);
        ok(GH.BurndownChartView);
    });

    test('Does not redraw the non-working days checkbox if it\'s already there', function () {
        QUnit.GhFixtures.addFixture('<div id="ghx-chart-view"><div class="legend"><table><tbody></tbody></table></div></div>');
        BurndownChartView.addNonWorkingDaysToLegend();

        // should have drawn the checkbox for non-working days
        equal($('#ghx-chart-view').find('tbody').children().length, 1);

        BurndownChartView.addNonWorkingDaysToLegend();

        // should not have drawn it again
        equal($('#ghx-chart-view').find('tbody').children().length, 1);
    });

    test('processChartData: display only warning if warning is in response and there are no data', sinon.test(function () {
        this.stub(BurndownChartView, 'renderUI');
        this.stub(BurndownChartView, 'showWarning');
        this.stub(BurndownChartModel, 'getWarning', function () {
            return 'Some warning';
        });
        this.stub(BurndownChartModel, 'isEmpty', function () {
            return true;
        });

        BurndownChartView.showChart();

        ok(!BurndownChartView.renderUI.called, 'Does not show chart');
        ok(BurndownChartView.showWarning.called, 'Shows warning');
    }));

    test('processChartData: display warning and chart if warning is in response with data', sinon.test(function () {
        this.stub(BurndownChartView, 'renderUI');
        this.stub(BurndownChartView, 'showWarning');
        this.stub(BurndownChartView, 'handleReopenButton');
        this.stub(BurndownChartModel, 'getWarning', function () {
            return 'Some warning';
        });
        this.stub(BurndownChartModel, 'isEmpty', function () {
            return false;
        });

        BurndownChartView.showChart();

        ok(BurndownChartView.renderUI.called, 'Shows chart');
        ok(BurndownChartView.showWarning.called, 'Shows warning');
    }));

    test('processChartData: display only chart if data are returned but data not', sinon.test(function () {
        this.stub(BurndownChartView, 'renderUI');
        this.stub(BurndownChartView, 'handleReopenButton');
        this.stub(BurndownChartModel, 'getWarning');
        this.stub(BurndownChartModel, 'isEmpty', function () {
            return false;
        });

        BurndownChartView.showChart();

        ok(BurndownChartView.renderUI.called, 'Shows chart');
        ok(!BurndownChartView.showWarning.called, 'Does not show warning');
    }));
});