/* global GH */
AJS.test.require(['com.pyxis.greenhopper.jira:gh-test-common', 'com.pyxis.greenhopper.jira:gh-test-dates', 'com.pyxis.greenhopper.jira:gh-rapid'], function() {
    var CFDController = require('jira-agile/rapid/ui/chart/cfd-controller');
    var ChartView = require('jira-agile/rapid/ui/chart/chart-view');

    // GLOBALS
    var Test = GH.Test;

    var config = {
        id: 1,
        columns: [],
        quickFilters: [],
        swimlanes: []
    };

    module('loadChartData', {
        setup: function() {
            Test.setUpFakeServer(this);
            CFDController.rapidViewConfig = config;
        },
        teardown: function() {
            Test.restoreServer(this);
        }
    });

    test('module "jira-agile/rapid/ui/chart/cfd-controller" exists', function() {
        ok(CFDController);
        ok(GH.CFDController);
    });

    test('loadChartData: successful Ajax request passes to process chart data', sinon.test(function() {
        this.stub(CFDController, 'processChartData');

        Test.respondToGetWith200(this, '/rapid/charts/cumulativeflowdiagram.json', {});

        CFDController.loadChartData();

        this.server.respond();

        ok(CFDController.processChartData.called, 'Called success method');
    }));

    test('loadChartData: failed Ajax request hides the spinner', sinon.test(function() {
        this.stub(CFDController, 'processChartData');
        this.stub(ChartView, 'hideSpinner');

        Test.respondToGetWith500(this, '/rapid/charts/cumulativeflowdiagram.json', {});

        CFDController.loadChartData();

        this.server.respond();

        ok(!CFDController.processChartData.called, 'Does not call process function on failure');
        ok(ChartView.hideSpinner.called, 'hides spinner on failure');
    }));
});
