AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-test-dates", "com.pyxis.greenhopper.jira:gh-rapid"], function () {
    module("Ajax function testing", {
        setup: function setup() {
            GH.Test.setUpFakeServer(this);
            GH.EpicReportController.rapidViewData = { id: 1 };
            GH.EpicReportController.rapidViewConfig = {
                estimationStatistic: {}
            };
            GH.EpicReportController.epicPicker = {
                getSelectedItem: function getSelectedItem() {
                    return { id: 1 };
                },
                removeSelectedItemAndRevert: function removeSelectedItemAndRevert() {}
            };
        },
        teardown: function teardown() {
            GH.Test.restoreServer(this);
        }
    });

    /* The purpose of these tests is to ensure the ajax calls are not broken while making a significant refactoring to how GH.Ajax works */
    test("loadEpicsList - successful AJAX call passes to next function", sinon.test(function () {

        this.stub(GH.EpicReportController, "processEpicData");

        GH.Test.respondToGetWith200(this, "/xboard/plan/backlog/epics.json", {});

        GH.EpicReportController.loadEpicsList();

        this.server.respond();

        ok(GH.EpicReportController.processEpicData.called, "Called success method");
    }));

    test("loadEpicsList - failed AJAX call hides the spinner", sinon.test(function () {
        this.stub(GH.ChartView, "hideSpinner");

        GH.Test.respondToGetWith500(this, "/xboard/plan/backlog/epics.json", {});

        GH.EpicReportController.loadEpicsList();

        this.server.respond();

        ok(GH.ChartView.hideSpinner.called, "Called failure method");
    }));

    test("loadReportData - successful Ajax calls call process functions", sinon.test(function () {
        this.stub(GH.EpicReportController, "processReportData");
        this.stub(GH.EpicReportController, "processChartData");

        GH.Test.respondToGetWith200(this, "/rapid/charts/epicreport", {});
        GH.Test.respondToGetWith200(this, "/rapid/charts/epicprogresschart", {});

        GH.EpicReportController.loadReportData();

        this.server.respond();

        ok(GH.EpicReportController.processReportData.called, "Called success method");
        ok(GH.EpicReportController.processChartData.called, "Called success method");
    }));

    test("loadReportData - failed Ajax calls hide the spinner", sinon.test(function () {
        this.stub(GH.ChartView, "hideSpinner");

        GH.Test.respondToGetWith500(this, "/rapid/charts/epicreport", {});
        GH.Test.respondToGetWith500(this, "/rapid/charts/epicprogresschart", {});

        GH.EpicReportController.loadReportData();

        this.server.respond();

        ok(GH.ChartView.hideSpinner.calledOnce, "Called failure method");
    }));
});