AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function() {
    module("Y Axis calculation");

    test("returns correct y axis for a duration", function() {

        // For a maximum of 5 days or 120 hours, expect a tick size of 1/8 or 15 hours
        var maxSeconds = 60 * 60 * 24 * 5;
        var fifteenHoursInSeconds = 15 * 60 * 60;

        var yAxis = GH.FlotChartUtils.calculateYAxis(maxSeconds, {renderer: "duration"});

        // check the tick size is set correctly
        equal(yAxis.tickSize, fifteenHoursInSeconds);

        ok(_.isFunction(yAxis.tickFormatter));
        // check we got the right tick formatter
        var formattedHours = yAxis.tickFormatter(60 * 60 * 10);

        equal(formattedHours, "10h");

    });

    test("min tick size is never less than 1 hour if there are some values of at least 8 seconds", function() {

        var yAxis = GH.FlotChartUtils.calculateYAxis(8, {renderer: "duration"});
        // check the tick size is set correctly
        equal(yAxis.tickSize, 3600);

    });

    test("just return a tick formatter when not duration or issue count", function() {
        var yAxis = GH.FlotChartUtils.calculateYAxis(1, {});

        // check tick size will be set by flot
        ok(!yAxis.tickSize);

        // check we got a formatter
        ok(_.isFunction(yAxis.tickFormatter));

        // ensure it formats numbers and decimals for story points
        yAxis.tickFormatter(120, "120");
        yAxis.tickFormatter(1.5, "1.5");
    });

    test("Sets minimum tick size to 1 for less than 15 issues with issue count scale", function() {
        var yAxis = GH.FlotChartUtils.calculateYAxis(1, { typeId: "issueCount"});
        equal(yAxis.minTickSize, 1);

        yAxis = GH.FlotChartUtils.calculateYAxis(14, { typeId: "issueCount"});
        equal(yAxis.minTickSize, 1);
    });

    test("Sets tick size to ensure 8 ticks with more than 15 issues for issue count scale", function() {
        var yAxis = GH.FlotChartUtils.calculateYAxis(15, { typeId: "issueCount"});
        equal(yAxis.tickSize, 2);

        yAxis = GH.FlotChartUtils.calculateYAxis(24, { typeId: "issueCount"});
        equal(yAxis.tickSize, 3);
    });

    test("Sets tick formatter to avoid decimal places for issue count scale", function() {
        var yAxis = GH.FlotChartUtils.calculateYAxis(15, { typeId: "issueCount"});
        ok(_.isFunction(yAxis.tickFormatter));

        equal(yAxis.tickFormatter(1.5), "2");
        equal(yAxis.tickFormatter(2.0), "2");
    });

    module("Gather points");

    test("Gathering of the points", function() {

        // create a series with three data points
        // each has two pieces of data
        var series = {
            datapoints: {
                points: [1358247922037, 0, 1358247922273, 1, 1358247922273, 2],
                pointsize: 2
            },
            series: {
                xaxis: {
                    p2c: function(v) { return v; } // fake point to canvas
                },
                yaxis: {
                    p2c: function(v) { return v; }
                }
            }
        };

        //GH.FlotChartUtils.gatherPoints();

        // todo: complete this test ... one day
        expect(0);
    });
});