AJS.test.require("com.pyxis.greenhopper.jira:gh-rapid", function() {
    module("ChartTimeFrameModel tests", {
        EARLIEST_DATE: new Date(2013, 0, 1, 14, 2, 30, 1),
        CURRENT_DATE: new Date(2013, 10, 30, 12, 45, 24, 2),
        END_OF_CURRENT_DATE: new Date(2013, 10, 30, 23, 59, 59, 999),

        getModelWithDefaultBounds: function() {
            return new GH.Reports.ChartTimeFrameModel().setBounds(this.EARLIEST_DATE, this.CURRENT_DATE);
        },

        assertTimeFrameDates: function(actualDates, expectedDates) {
            strictEqual(actualDates.fromDate.toString(), expectedDates.fromDate.toString(), "from date is correct");
            strictEqual(actualDates.toDate.toString(), expectedDates.toDate.toString(), "to date is correct");
        }
    });

    test("All time", function() {
        var model = this.getModelWithDefaultBounds().setAllTime();
        this.assertTimeFrameDates(model.getTimeFrameDates(), {
            fromDate: new Date(2013, 0, 1),
            toDate: this.END_OF_CURRENT_DATE
        });
    });

    test("Last 10 days", function() {
        var model = this.getModelWithDefaultBounds().setDays(10);
        this.assertTimeFrameDates(model.getTimeFrameDates(), {
            fromDate: new Date(2013, 10, 21),
            toDate: this.END_OF_CURRENT_DATE
        });
    });

    test("Simple dates", function() {
        var model = this.getModelWithDefaultBounds().setSimpleDates(new Date(2013, 1, 2), new Date(2013, 2, 2));
        this.assertTimeFrameDates(model.getTimeFrameDates(), {
            fromDate: new Date(2013, 1, 2),
            toDate: new Date(2013, 2, 2, 23, 59, 59, 999)
        });
    });

    test("Simple dates on the same day", function() {
        var model = this.getModelWithDefaultBounds().setSimpleDates(new Date(2013, 1, 2), new Date(2013, 1, 2));
        this.assertTimeFrameDates(model.getTimeFrameDates(), {
            fromDate: new Date(2013, 1, 2),
            toDate: new Date(2013, 1, 2, 23, 59, 59, 999)
        });
    });

    test("Simple dates ignore hour/minute/second/ms values", function() {
        var model = this.getModelWithDefaultBounds().setSimpleDates(
            new Date(2013, 1, 2, 10, 10, 10, 100),
            new Date(2013, 2, 2, 20, 20, 20, 200)
        );
        this.assertTimeFrameDates(model.getTimeFrameDates(), {
            fromDate: new Date(2013, 1, 2),
            toDate: new Date(2013, 2, 2, 23, 59, 59, 999)
        });
    });

    test("Exact dates preserve hour/minute/second/ms values", function() {
        var fromDate = new Date(2013, 1, 2, 10, 10, 10, 100);
        var toDate = new Date(2013, 2, 2, 20, 20, 20, 200);
        var model = this.getModelWithDefaultBounds().setExactDates(fromDate, toDate);
        this.assertTimeFrameDates(model.getTimeFrameDates(), {
            fromDate: fromDate,
            toDate: toDate
        });
    });

    test("Duration", function() {
        var model = this.getModelWithDefaultBounds().setDays(10);
        strictEqual(model.getTimeFrameDuration(), 10 * 24 * 60 * 60 * 1000, "Duration is correct");
    });

    test("Cloning", function() {
        var model = this.getModelWithDefaultBounds().setDays(30);
        var clone = model.clone();
        strictEqual(clone.getTimeFrame(), 30, "Time frame is copied");
        equal(clone.earliestDate, null, "Earliest date is not copied");
        equal(clone.currentDate, null, "Current date is not copied");

        clone.setDays(20);
        equal(model.getTimeFrame(), 30, "Clone is independent from original");
    });

    test("An arbitrary value for 'days' returns 'custom' from the timeframe model", function() {
        var model = this.getModelWithDefaultBounds().setDays(15); // some arbitrary timeframe

        strictEqual(model.getTimeFrame(), 'custom', "'custom' is returned from the timeframe model.");
    });
});