/* global moment: true */
/**
 * Displays a dialog relating to a the work estimates in a sprint.
 */

(function(d3, Reports, InlineDialog, SideInlineDialog, Ajax) {
    var DIALOG_ID = 'scope-by-sprint-dlg';
    var SCROLL_CONTAINER = '#ghx-report-scrollarea > .aui-page-panel';
    var DATE_FORMAT = 'LL';
    var dialog;
    var selectedSprintId = null;

    InlineDialog.preventCloseOnClick(DIALOG_ID);

    function formatSprint(sprint, estimationStatistic) {
        var estimateFormatter = estimationStatistic.formatter.formatFull;
        if (sprint.startTime && sprint.endTime) {
            sprint.formattedStartDate = moment(sprint.startTime).format(DATE_FORMAT);
            sprint.formattedEndDate = moment(sprint.endTime).format(DATE_FORMAT);
        }

        sprint.formattedWorkAtStart = estimateFormatter(sprint.workAtStart);
        sprint.formattedWorkAdded = estimateFormatter(sprint.workAdded);
        sprint.formattedWorkRemoved = estimateFormatter(sprint.workRemoved);
        sprint.formattedWorkCompleted = estimateFormatter(sprint.workCompleted);
        sprint.formattedWorkRemaining = estimateFormatter(sprint.workRemaining);

        return sprint;
    }

    function renderSprint(sprint, estimationStatistic, labels) {
        var sprintReportUri = '';

        if ((!sprint.isForecast || sprint.isActive) && sprint.sprintId !== 'original') {
            sprintReportUri = Ajax.buildBareRestUrl('secure/RapidBoard.jspa?rapidView=' + sprint.rapidViewId + '&view=reporting&chart=sprintRetrospective&sprint=' + sprint.sprintId)
        }

        return GH.tpl.reports.scopeBurndownBySprint.renderSprintScopeDialogContent({
            sprint: formatSprint(sprint, estimationStatistic),
            estimationStatistic: estimationStatistic,
            url: sprintReportUri,
            labels: labels
        });
    }

    function show(trigger, sprint, estimationStatistic, labels) {
        if (isVisible() && sprint.sprintId === selectedSprintId) {
            dialog.hide();
        } else {
            // use d3 to manipulate the classes since jQuery/ie don't support addClass/classList for svg elements.
            var triggerElement = d3.select(trigger);
            triggerElement.classed('active', true);

            dialog = SideInlineDialog.create(DIALOG_ID, trigger, function($content, $trigger, showPopup) {
                $content.closest('.aui-inline-dialog').addClass('ghx-inline-dialog');
                $content.html(renderSprint(sprint, estimationStatistic, labels));
                showPopup();
            }, {
                addActiveClass: false,
                container: SCROLL_CONTAINER,
                fadeTime: 0,
                noBind: true,
                cacheContent: false, // don't cache the dialog content
                hideDelay: 60000, // set longer timeout (default is 10 seconds)
                persistent: true,
                offsetX: 8,
                hideCallback: function() {
                    triggerElement.classed('active', false);
                }
            });
            selectedSprintId = sprint.sprintId;
            dialog.show();
        }

        return dialog;
    }

    function isVisible() {
        return dialog ? dialog.is(":visible") : false;
    }

    GH.Reports.ScopeBurndownBySprintChartDialog =  {
        /**
         * Create and show a dialog for a sprint
         *
         * @param {Element} trigger - element to position the dialog next to
         * @param {sprint} sprint - renders sprint details and scope
         * @return {InlineDialog}
         */
        show: show,
        /**
         * Hides dialog if it is showing
         */
        hide: function() {
            if (dialog) {
                dialog.hide();
                selectedSprintId = null;
            }
        },
        /**
         * Test if there is an instance of this dialog already visible.
         */
        isVisible: isVisible
    };
}(d3, GH.Reports, GH.InlineDialog, GH.SideInlineDialog, GH.Ajax));