/* global GH */
define('jira-agile/rapid/ui/chart/v2/controlchart/control-chart-refinements-controller', ['require'], function (require) {
    'use strict';

    var view = GH.Reports.ControlChartRefinementsView;

    var ControlChartController;
    var GlobalEvents = require('jira-agile/rapid/global-events');
    GlobalEvents.on('pre-initialization', function () {
        ControlChartController = require('jira-agile/rapid/ui/chart/v2/controlchart/control-chart-controller');
    });

    var handlers = {

        /**
         * Inform parent controller that the model has changed
         */
        modelChanged: function modelChanged() {
            ControlChartController.update();
        },

        /**
         * Override selected refinements with the defaults for the current board
         */
        resetToDefaults: function resetToDefaults() {
            view.getModel().resetToDefaults();

            view.digest();
        }
    };

    /**
     * Sets up handlers for view to delegate to
     */
    function bindViewHandlers() {
        view.setHandler(function (command) {
            handlers[command]();
        });
    }

    return {
        /**
         * @lends GH.Reports.ControlChartRefinementsController
         */
        start: function start(refinements) {
            bindViewHandlers();
            view.start(refinements);
            view.digest();
        },

        resetToDefaults: handlers.resetToDefaults
    };
});