AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid-config"], function() {

    var EstimationConfig = require('jira-agile/rapid/configuration/estimation-config');

    module("Ajax tests", {
        setup: function() {
            GH.Test.setUpFakeServer(this);
            EstimationConfig.model = {
                rapidViewId: 1
            };
        },
        teardown: function() {
            GH.Test.restoreServer(this);
        }
    });

    /**** TODO - tests need rewriting
     test("submitSprintData: Successful AJAX call updates the sprint data", sinon.test(function() {

        GH.Test.respondToPutWith200(this, "/sprint/", {});

        var inlineEdit = new GH.Components.ActiveSprintInlineEdit();
        this.stub(inlineEdit, "updateSprintData");

        inlineEdit.submitSprintData({id: 1});

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(inlineEdit.updateSprintData.called, "Called success method");

    }));

     test("save: Failed AJAX call does nothing (no error handling)", sinon.test(function() {

        GH.Test.respondToPutWith500(this, "/sprint/", {});

        var inlineEdit = new GH.Components.ActiveSprintInlineEdit();
        this.stub(inlineEdit, "updateSprintData");

        inlineEdit.submitSprintData({id: 1});

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(!inlineEdit.updateSprintData.called, "Called success method");
    }));
     */

    test("submitSprintData: Successful AJAX call triggers sprint update event with data", sinon.test(function() {

        var url = new RegExp("^" + GH.Ajax.buildRestUrl("/sprint/") + "(.*)");
        var successData = { data: "blah"};
        this.server.respondWith("PUT", url, [200, { "Content-Type": "application/json" }, JSON.stringify(successData)]);

        var inlineEdit = new GH.Components.ActiveSprintInlineEdit();
        var eventTester = new GH.Test.EventTester(GH.Components.EVENT_SPRINT_UPDATED);

        inlineEdit.submitSprintData({id: 1});

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(eventTester.eventWasFired());
        deepEqual(eventTester.getEventData(), successData);

    }));

    test("submitSprintData: Failed AJAX call does not fire event", sinon.test(function() {

        var url = new RegExp("^" + GH.Ajax.buildRestUrl("/sprint/") + "(.*)");
        this.server.respondWith("PUT", url, [500, { "Content-Type": "application/json" }, JSON.stringify({})]);

        var inlineEdit = new GH.Components.ActiveSprintInlineEdit();
        var eventTester = new GH.Test.EventTester(GH.Components.EVENT_SPRINT_UPDATED);

        inlineEdit.submitSprintData({id: 1});

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(!eventTester.eventWasFired());
    }));

    module("Sprint Name validation", {
        setup: function() {
            GH.Test.setUpFakeServer(this);
            GH.Components.SPRINT_NAME_MAX_LENGTH = 10;
            GH.tpl.rapid.notification.renderContextualErrors = sinon.stub();
        },
        teardown: function() {
            GH.Test.restoreServer(this);
        }
    });

    test("not valid if it's blank", function() {
        QUnit.GhFixtures.addFixture("<input type='text' value='' id='editbox'>");
        var sprintEdit = new GH.Components.ActiveSprintInlineEdit();
        ok(!sprintEdit.validateName({editElement: AJS.$("#editbox"), sprintData: {}}));
    });

    test("not valid if it's longer than the max length", function() {
        QUnit.GhFixtures.addFixture("<input type='text' value='abcdefghijk' id='editbox'>");
        var sprintEdit = new GH.Components.ActiveSprintInlineEdit();
        ok(!sprintEdit.validateName({editElement: AJS.$("#editbox"), sprintData: {}}));
    });

    test("valid if it's between 1-10 characters", function() {
        QUnit.GhFixtures.addFixture("<input type='text' value='abcdef' id='editbox'>");
        var sprintEdit = new GH.Components.ActiveSprintInlineEdit();
        ok(sprintEdit.validateName({editElement: AJS.$("#editbox"), sprintData: {}}));
    });

    test("submitSprintData: Successful Ajax request triggers an event", sinon.test(function() {
        var eventTester = new GH.Test.EventTester(GH.Components.EVENT_SPRINT_UPDATED);
        var sprintEdit = new GH.Components.ActiveSprintInlineEdit();

        var url = new RegExp("^" + GH.Ajax.buildRestUrl('/sprint/') + "(.*)");
        this.server.respondWith("PUT", url, [200, { "Content-Type": "application/json" }, JSON.stringify({})]);

        sprintEdit.submitSprintData({
            id: 2,
            name: "Sprint 2"
        });

        this.server.respond();

        ok(eventTester.eventWasFired());
    }));

    test("updateOpenSprint: Failed request does not trigger update event", sinon.test(function() {
        var eventTester = new GH.Test.EventTester(GH.Components.EVENT_SPRINT_UPDATED);
        var sprintEdit = new GH.Components.ActiveSprintInlineEdit();

        var url = new RegExp("^" + GH.Ajax.buildRestUrl('/sprint/') + "(.*)");
        this.server.respondWith("PUT", url, [500, { "Content-Type": "application/json" }, JSON.stringify({})]);

        sprintEdit.submitSprintData({
            id: 2,
            name: "Sprint 2"
        });

        this.server.respond();

        ok(!eventTester.eventWasFired());
    }));
});