/*
 * BoardAdminsPicker
 * --------------------------------------------
 * an adaption for multi-select from
 * resources/includes/js/rapid/ui/component/ProjectPicker.js
 */
/* global _ */

GH.RapidBoard.BoardAdminsPicker = function(options) {
    this.selector = options.selector;
    this.change = options.change;
    this.initialData = options.initialData;
    this.editData = options.editData;
    this.blur = options.blur;
};

GH.RapidBoard.BoardAdminsPicker.prototype.show = function() {
    var $select = AJS.$(this.selector);
    this.select = $select;
    this.multiselect = new AJS.MultiSelect({
        element: $select,
        width:400,
        errorMessage: "",
        itemAttrDisplayed: "label",
        ajaxOptions: {
            url: GH.Ajax.CONTEXT_PATH + GH.Ajax.REST_URL_BASE + "/rapidviewconfig/boardadminspicker?maxResults=15",
            formatResponse: function (response) {
                var descriptor;
                var groupsGroupDescriptor = new AJS.GroupDescriptor({
                    weight: 0,
                    label: AJS.I18n.getText("gh.configuration.board.admin.no.picker.groups")
                });
                var usersGroupDescriptor = new AJS.GroupDescriptor({
                    weight: 1,
                    label: AJS.I18n.getText("gh.configuration.board.admin.no.picker.users")
                });

                _.each(response.users, function(user) {
                    user.key = user.key || user.name;
                    var label = user.displayName + " (" + user.name + ")";
                    descriptor = GH.RapidBoard.BoardAdminsPicker.buildItemDescriptor("user", user.key, label, label);
                    usersGroupDescriptor.addItem(descriptor);
                });

                _.each(response.groups, function(group) {
                    descriptor = GH.RapidBoard.BoardAdminsPicker.buildItemDescriptor("group", group.name, group.name, group.name);
                    groupsGroupDescriptor.addItem(descriptor);
                });

                return [groupsGroupDescriptor, usersGroupDescriptor];
            },
            query: true
        }
    });

    this.multiselect._addMultipleItems(this.initialData);
    this.select.bind("unselect", this.change);
    this.select.bind("change", this.change);

    this.multiselect.$field.focus();
    this.multiselect.$field.blur(this.blur);
};

GH.RapidBoard.BoardAdminsPicker.prototype.getAjaxValue = function() {
    var editedBoardAdmins = this.getValue();
    var parsedData = {
        userKeys: [],
        groupKeys: []
    };
    if (editedBoardAdmins == null) {
        return parsedData;
    }
    _.each(editedBoardAdmins, function(elem) {
        var parts = elem.split(":");

        var type = parts[0], key = parts[1];

        if (parts.length < 2) {
            return;
        }
        if (type == "user") {
            parsedData.userKeys.push(key);
        }
        if (type == "group") {
            parsedData.groupKeys.push(key);
        }
    });
    return parsedData;
};

GH.RapidBoard.BoardAdminsPicker.buildItemDescriptor = function(prefix, value, label, html) {
    return new AJS.ItemDescriptor({
        value: prefix + ":" + value,
        label: label,
        html: AJS.escapeHTML(String(html))
    });
};

GH.RapidBoard.BoardAdminsPicker.prototype.hasValue = function() {
    return !!this.select.val();
};

GH.RapidBoard.BoardAdminsPicker.prototype.hasErrors = function() {
    return this.multiselect.$container.parent().find(".error").length > 0;
};

GH.RapidBoard.BoardAdminsPicker.prototype.getValue = function() {
    return this.select.val();
};

GH.RapidBoard.BoardAdminsPicker.prototype.getElement = function() {
    return this.select;
};

/*
 * ---------------------------------------------------------------------------------------------------------------------
 * Helper Functions
 */

GH.RapidBoard.BoardAdminsPicker.sortModel = function(model) {
    var sorter = function(a, b) {
        return a.displayName.toLowerCase().localeCompare(b.displayName.toLowerCase());
    };
    return {
        userKeys: model.userKeys.sort(sorter),
        groupKeys: model.groupKeys.sort(sorter)
    };
};

GH.RapidBoard.BoardAdminsPicker.getOrderedUnion = function(model) {
    var sortedModel = GH.RapidBoard.BoardAdminsPicker.sortModel(model);

    return _.union(sortedModel.groupKeys, sortedModel.userKeys);
};

