GH.PageIssueLinksModel = {};
GH.PageIssueLinksModel.model = {};

// TODO add the entity type to avoid id collisions
GH.PageIssueLinksModel.set = function(entityId, links){
    GH.PageIssueLinksModel.model[entityId] = links;
};

GH.PageIssueLinksModel.get = function(entityId, linkId){
    return _.find(GH.PageIssueLinksModel.model[entityId], function(link){
        return link.id === linkId;
    });
};

GH.PageIssueLinksModel.list = function(entityId){
    return GH.PageIssueLinksModel.model[entityId] || [];
};

GH.PageIssueLinksModel.removeLink = function(entityId, linkId){
    linkId = parseInt(linkId, 10);
    GH.PageIssueLinksModel.model[entityId] = _.reject(GH.PageIssueLinksModel.model[entityId], function(page) {
        return page.id === linkId;
    });
};

GH.PageIssueLinksModel.addLink = function(entityId, link){
    if(!_.isArray(GH.PageIssueLinksModel.model[entityId])){
        GH.PageIssueLinksModel.model[entityId] = [];
    }
    GH.PageIssueLinksModel.model[entityId].push(link);
};

GH.PageIssueLinksModel.clear = function(entityId){
    delete GH.PageIssueLinksModel.model[entityId];
};
