AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid-config"], function () {
    module("Ajax tests", {
        setup: function setup() {
            GH.Test.setUpFakeServer(this);
            this.editInfo = {
                enabled: true,
                editControl: {
                    val: function val() {},
                    unbind: function unbind() {
                        return AJS.$();
                    }
                },
                editDd: AJS.$(),
                fieldData: {
                    text: ""
                },
                editor: {},
                model: {
                    getIssueId: function getIssueId() {}
                }
            };
            this.editInfo.editor.returnToEdit = sinon.stub();
        },
        teardown: function teardown() {
            GH.Test.restoreServer(this);
        }
    });

    test("submitSprintData: Successful AJAX call updates the sprint data", sinon.test(function () {

        this.stub(GH.DetailsFieldEdit, "handleFieldUpdateSuccess");
        GH.Test.respondToPutWith200(this, "/xboard/issue/update-field.json", {});

        var detailControl = new GH.DetailsFieldEditControl();
        detailControl.submitChanges(this.editInfo);

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(GH.DetailsFieldEdit.handleFieldUpdateSuccess.called, "Called success method");
        ok(!this.editInfo.editor.returnToEdit.called, "Error method not called");
    }));

    test("save: Failed AJAX call does nothing (no error handling)", sinon.test(function () {

        this.stub(GH.DetailsFieldEdit, "handleFieldUpdateSuccess");
        GH.Test.respondToPutWith500(this, "/xboard/issue/update-field.json", {});

        var detailControl = new GH.DetailsFieldEditControl();
        detailControl.submitChanges(this.editInfo);

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(!GH.DetailsFieldEdit.handleFieldUpdateSuccess.called, "Success method not called");
        ok(this.editInfo.editor.returnToEdit.called, "Error method called");
    }));
});